/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.DrillReplace;
import com.tonbeller.jpivot.test.olap.TestAxis;
import com.tonbeller.jpivot.test.olap.TestExtensionSupport;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import com.tonbeller.jpivot.test.olap.TestMember;
import com.tonbeller.jpivot.test.olap.TestOlapModelUtils;
import com.tonbeller.jpivot.test.olap.TestPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class TestDrillReplace
extends TestExtensionSupport
implements DrillReplace {
    @Override
    public boolean canDrillDown(Member member) {
        return ((TestMember)member).hasChildren();
    }

    @Override
    public boolean canDrillUp(Hierarchy hier) {
        TestAxis axis = TestOlapModelUtils.findAxis(this.model(), hier);
        int memberIndex = TestOlapModelUtils.indexOf(axis.getHierarchies(), hier);
        Iterator it = axis.getPositions().iterator();
        while (it.hasNext()) {
            Member m = ((Position)it.next()).getMembers()[memberIndex];
            if (m.getRootDistance() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void drillDown(Member member) {
        TestMember tm = (TestMember)member;
        TestOlapModelUtils.setVisible(tm.getChildMember());
        TestOlapModelUtils.rebuildAxis(this.model(), (TestMember)member);
        this.fireModelChanged();
    }

    @Override
    public void drillUp(Hierarchy hier) {
        HashSet<TestMember> parents = new HashSet<TestMember>();
        ArrayList<TestMember> memberList = new ArrayList<TestMember>();
        TestAxis axis = TestOlapModelUtils.findAxis(this.model(), hier);
        int memberIndex = TestOlapModelUtils.indexOf(axis.getHierarchies(), hier);
        for (TestPosition position : axis.getPositions()) {
            TestMember member = (TestMember)position.getMembers()[memberIndex];
            TestMember parent = member.getParentMember();
            if (parent == null) continue;
            Displayable key = parent.getParentMember();
            if (key == null) {
                key = hier;
            }
            if (parents.contains(key)) continue;
            parents.add((TestMember)key);
            TestMember grandpa = parent.getParentMember();
            if (grandpa == null) {
                TestMember[] members = ((TestHierarchy)hier).getRootMembers();
                memberList.addAll(Arrays.asList(members));
                continue;
            }
            memberList.addAll(grandpa.getChildMember());
        }
        TestOlapModelUtils.setVisible(memberList);
        TestOlapModelUtils.rebuildAxis(this.model(), axis);
        this.fireModelChanged();
    }
}

