/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.mdxparse.ParsedQuery;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.ChangeSlicer;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.jpivot.util.ArrayUtil;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_QueryAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class XMLA_ChangeSlicer
extends ExtensionSupport
implements ChangeSlicer {
    static Logger logger = Logger.getLogger(XMLA_ChangeSlicer.class);

    public XMLA_ChangeSlicer() {
        super.setId("changeSlicer");
    }

    @Override
    public Member[] getSlicer() {
        XMLA_Model model = (XMLA_Model)this.getModel();
        Result res = null;
        try {
            res = model.getResult();
        }
        catch (OlapException ex) {
            return new Member[0];
        }
        Axis slicer = res.getSlicer();
        List positions = slicer.getPositions();
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position pos : positions) {
            Member[] posMembers = pos.getMembers();
            for (int i = 0; i < posMembers.length; ++i) {
                if (members.contains(posMembers[i])) continue;
                members.add(posMembers[i]);
            }
        }
        return members.toArray(new Member[0]);
    }

    @Override
    public void setSlicer(Member[] members) {
        XMLA_Model model = (XMLA_Model)this.getModel();
        XMLA_QueryAdapter adapter = (XMLA_QueryAdapter)model.getQueryAdapter();
        ParsedQuery pq = adapter.getParsedQuery();
        boolean logInfo = logger.isInfoEnabled();
        if (members.length == 0) {
            pq.setSlicer(null);
            if (logInfo) {
                logger.info((Object)"slicer set to null");
            }
        } else {
            FunCall f = new FunCall("()", (XMLA_Member[])ArrayUtil.naturalCast(members), 6);
            pq.setSlicer(f);
            if (logInfo) {
                StringBuffer sb = new StringBuffer("slicer=(");
                for (int i = 0; i < members.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(((MDXElement)((Object)members[i])).getUniqueName());
                }
                sb.append(")");
                logger.info((Object)sb.toString());
            }
        }
        model.fireModelChanged();
    }
}

