/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.xmla.XMLA_Axis;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_QueryAdapter;
import com.tonbeller.jpivot.xmla.XMLA_Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class XMLA_PlaceHierarchies
extends ExtensionSupport
implements PlaceHierarchiesOnAxes {
    private boolean expandAllMember = false;
    ArrayList aMemberSet = null;
    static Logger logger = Logger.getLogger(XMLA_PlaceHierarchies.class);

    public XMLA_PlaceHierarchies() {
        super.setId("hierarchiesOnAxes");
    }

    @Override
    public Object createMemberExpression(Hierarchy hier) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        XMLA_QueryAdapter adapter = (XMLA_QueryAdapter)model.getQueryAdapter();
        Quax quax = adapter.findQuax(hier.getDimension());
        if (quax == null) {
            return XMLA_Util.topLevelMembers(hier, this.expandAllMember);
        }
        int iDimension = quax.dimIdx(hier.getDimension());
        return quax.genExpForDim(iDimension);
    }

    @Override
    public void setQueryAxis(Axis target, Object[] memberExpressions) {
        XMLA_Model model = (XMLA_Model)this.getModel();
        XMLA_QueryAdapter adapter = (XMLA_QueryAdapter)model.getQueryAdapter();
        int iQuax = ((XMLA_Axis)target).getOrdinal();
        if (adapter.isSwapAxes()) {
            iQuax = (iQuax + 1) % 2;
        }
        Quax quax = adapter.getQuaxes()[iQuax];
        int nDimension = memberExpressions.length;
        Object[] sets = new Object[nDimension];
        boolean changedMemberSet = false;
        for (int i = 0; i < nDimension; ++i) {
            if (memberExpressions[i] instanceof List) {
                List memberList = (List)memberExpressions[i];
                Exp[] members = memberList.toArray(new Exp[0]);
                sets[i] = members.length == 1 ? members[0] : new FunCall("{}", members, 5);
                changedMemberSet = true;
                continue;
            }
            sets[i] = memberExpressions[i];
        }
        quax.regeneratePosTree(sets, true);
        if (logger.isInfoEnabled()) {
            String changed = "";
            if (changedMemberSet) {
                changed = " changed by navi";
            }
            logger.info((Object)("setQueryAxis axis=" + quax.getOrdinal() + " nDimension=" + nDimension + changed));
            logger.info((Object)("Expression for Axis=" + quax.toString()));
        }
        quax.changed(this, changedMemberSet);
        model.fireModelChanged();
    }

    @Override
    public void setExpandAllMember(boolean expandAllMember) {
        this.expandAllMember = expandAllMember;
    }

    @Override
    public boolean getExpandAllMember() {
        return this.expandAllMember;
    }
}

