/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.CompoundId;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.mdxparse.Parameter;
import com.tonbeller.jpivot.olap.mdxparse.ParsedQuery;
import com.tonbeller.jpivot.olap.mdxparse.QueryAxis;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxChangeListener;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.util.StringUtil;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_MemberProperties;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_Quax;
import com.tonbeller.jpivot.xmla.XMLA_Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class XMLA_QueryAdapter
extends QueryAdapter
implements QuaxChangeListener {
    static Logger logger = Logger.getLogger(XMLA_QueryAdapter.class);
    private ParsedQuery parsedQuery;
    private ParsedQuery cloneQuery;
    private XMLA_Result result;
    private String originalMDX;
    private int nAxes;

    XMLA_QueryAdapter(XMLA_Model model) {
        super(model);
        this.genMDXHierarchize = true;
        this.parsedQuery = model.getPQuery();
        QueryAxis[] queryAxes = this.parsedQuery.getAxes();
        this.nAxes = queryAxes.length;
        this.quaxes = new XMLA_Quax[this.nAxes];
        for (int i = 0; i < this.nAxes; ++i) {
            this.quaxes[i] = new XMLA_Quax(i, queryAxes[i], model);
            this.quaxes[i].addChangeListener(this);
        }
    }

    @Override
    public void quaxChanged(Quax quax, Object source, boolean changedByNavi) {
        this.useQuax = true;
        Map paraMap = this.parsedQuery.getParaMap();
        int iOrdinal = quax.getOrdinal();
        Collection params = paraMap.values();
        ArrayList<String> removeList = new ArrayList<String>();
        for (Parameter param : params) {
            int iAxis = param.getIAxis();
            if (iAxis != iOrdinal) continue;
            removeList.add(param.getName().toUpperCase());
        }
        for (String objToRemove : removeList) {
            paraMap.remove(objToRemove);
        }
    }

    @Override
    public Quax[] getQuaxes() {
        return this.quaxes;
    }

    protected void onExecute() {
        Map cmpmap;
        if (this.useQuax) {
            int iQuaxToSort = -1;
            if (this.sortMan != null) {
                iQuaxToSort = this.sortMan.activeQuaxToSort();
            }
            QueryAxis[] qAxes = this.parsedQuery.getAxes();
            for (int i = 0; i < this.quaxes.length; ++i) {
                boolean doHierarchize = false;
                if (this.genMDXHierarchize && this.quaxes[i].isHierarchizeNeeded() && i != iQuaxToSort) {
                    doHierarchize = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"MDX Generation added Hierarchize()");
                    }
                }
                Exp eSet = (Exp)this.quaxes[i].genExp(doHierarchize);
                qAxes[i].setExp(eSet);
            }
        }
        QueryAxis[] qAxes = this.parsedQuery.getAxes();
        for (int i = 0; i < this.quaxes.length; ++i) {
            XMLA_MemberProperties mPropExt = (XMLA_MemberProperties)this.model.getExtension("memberProperties");
            MemberPropertyMeta[] mprops = null;
            if (mPropExt != null) {
                mprops = mPropExt.getVisibleProperties();
            }
            if (mprops == null || mprops.length <= 0) continue;
            ArrayList<CompoundId> dProps = new ArrayList<CompoundId>();
            for (int j = 0; j < mprops.length; ++j) {
                String hierUname = mprops[j].getScope();
                XMLA_Hierarchy hier = ((XMLA_Model)this.model).lookupHierByUName(hierUname);
                if (hier == null) continue;
                String dimUname = hier.getDimUniqueName();
                Dimension dim = hier.getDimension();
                Quax q = this.findQuax(dim);
                if (q == null || !this.quaxes[i].equals(q)) continue;
                CompoundId cid = new CompoundId(dimUname);
                String propName = mprops[j].getName();
                cid.append(StringUtil.bracketsAround(propName));
                dProps.add(cid);
            }
            qAxes[i].setDimProps(dProps);
        }
        if (this.sortMan != null) {
            if (!this.useQuax) {
                if (this.cloneQuery == null) {
                    if (this.sortMan.isSortOnQuery()) {
                        this.cloneQuery = (ParsedQuery)this.parsedQuery.clone();
                    }
                } else {
                    this.parsedQuery = this.sortMan.isSortOnQuery() ? (ParsedQuery)this.cloneQuery.clone() : this.cloneQuery;
                }
            }
            this.sortMan.addSortToQuery();
        }
        if (this.axesSwapped) {
            this.swapAxes();
        }
        if ((cmpmap = ((XMLA_Model)this.model).getCalcMeasurePropMap()) != null && cmpmap.size() > 0) {
            List cellProps = this.parsedQuery.getCellProps();
            CompoundId cid = new CompoundId("FONT_SIZE", false);
            boolean found = false;
            for (CompoundId ci : cellProps) {
                if (!ci.toMdx().equalsIgnoreCase("FONT_SIZE")) continue;
                found = true;
                break;
            }
            if (!found) {
                cellProps.add(cid);
            }
        }
        long t1 = System.currentTimeMillis();
        String mdx = this.parsedQuery.toMdx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)mdx);
        }
        long t2 = System.currentTimeMillis();
        logger.info((Object)("monQuery.toString took " + (t2 - t1) + " millisec"));
        ((XMLA_Model)this.model).setCurrentMdx(mdx);
    }

    protected void onExecuteDrill() {
        long t1 = System.currentTimeMillis();
        String mdx = this.parsedQuery.toDrillMdx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)mdx);
        }
        long t2 = System.currentTimeMillis();
        logger.info((Object)("monQuery.toString took " + (t2 - t1) + " millisec"));
        ((XMLA_Model)this.model).setCurrentMdx(mdx);
    }

    String getCurrentMdx() {
        String mdx = this.parsedQuery.toMdx();
        return mdx;
    }

    public ParsedQuery getParsedQuery() {
        return this.parsedQuery;
    }

    @Override
    protected Object createMemberSet(List memList) {
        Exp[] exps = new Exp[memList.size()];
        int i = 0;
        for (XMLA_Member m : memList) {
            exps[i++] = m;
        }
        FunCall f = new FunCall("{}", exps, 5);
        return f;
    }

    @Override
    public boolean canExpand(Member member) {
        if (((XMLA_Member)member).isCalculated()) {
            return false;
        }
        if (!this.isDrillable(member, false)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canExpand(member);
    }

    @Override
    public boolean canExpand(Member[] pathMembers) {
        Member m = pathMembers[pathMembers.length - 1];
        if (((XMLA_Member)m).isCalculated()) {
            return false;
        }
        if (!this.isDrillable(m, false)) {
            return false;
        }
        Dimension dim = m.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canExpand(pathMembers);
    }

    @Override
    public void expand(Member member) {
        XMLA_Member m = (XMLA_Member)member;
        if (this.isDrillable(m, true)) {
            super.expand(member);
        } else {
            this.model.fireModelChanged();
        }
    }

    @Override
    public void expand(Member[] pathMembers) {
        XMLA_Member m = (XMLA_Member)pathMembers[pathMembers.length - 1];
        if (this.isDrillable(m, true)) {
            super.expand(pathMembers);
        } else {
            this.model.fireModelChanged();
        }
    }

    @Override
    public boolean canCollapse(Member member) {
        if (((XMLA_Member)member).isCalculated()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canCollapse(member);
    }

    @Override
    public boolean canCollapse(Member[] pathMembers) {
        Member member = pathMembers[pathMembers.length - 1];
        if (((XMLA_Member)member).isCalculated()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canCollapse(pathMembers);
    }

    @Override
    public boolean canDrillDown(Member member) {
        if (!this.isDrillable(member, false)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canDrillDown(member);
    }

    void setSwapAxes(boolean swap) {
        if (this.parsedQuery.getAxes().length >= 2) {
            this.axesSwapped = swap;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("swapAxes " + this.axesSwapped));
            }
            this.model.fireModelChanged();
        }
    }

    private void swapAxes() {
        QueryAxis[] queryAxes = this.parsedQuery.getAxes();
        if (queryAxes.length >= 2) {
            Exp exp = queryAxes[0].getExp();
            queryAxes[0].setExp(queryAxes[1].getExp());
            queryAxes[1].setExp(exp);
        }
    }

    private boolean isDrillable(Member member, boolean allowComplete) {
        XMLA_Member m = (XMLA_Member)member;
        long ccard = m.getChildrenCardinality();
        if (ccard >= 0L) {
            return ccard > 0L;
        }
        XMLA_Level level = (XMLA_Level)member.getLevel();
        XMLA_Model xmod = (XMLA_Model)this.model;
        XMLA_Hierarchy hier = (XMLA_Hierarchy)level.getHierarchy();
        if (xmod.isMicrosoft() && hier.getStructure() == 0 && level.getChildLevel() != null) {
            return true;
        }
        if (!allowComplete) {
            return true;
        }
        try {
            xmod.completeMember(m);
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return false;
        }
        return m.getChildrenCardinality() > 0L;
    }
}

