/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.keys.box.BoxStyleKeys;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.page.PageStyleKeys;
import org.pentaho.reporting.libraries.css.model.CSSPageRule;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;

public class StyleSheetUtility {
    private StyleSheetUtility() {
    }

    public static CSSPageRule createRuleForPage(StyleSheet style, PageFormat format) {
        CSSPageRule rule = new CSSPageRule(style, null, null, null);
        StyleSheetUtility.updateRuleForPage(rule, format);
        return rule;
    }

    public static void updateRuleForPage(CSSPageRule rule, PageFormat format) {
        if (format == null) {
            rule.removeProperty(BoxStyleKeys.MARGIN_TOP);
            rule.removeProperty(BoxStyleKeys.MARGIN_LEFT);
            rule.removeProperty(BoxStyleKeys.MARGIN_BOTTOM);
            rule.removeProperty(BoxStyleKeys.MARGIN_RIGHT);
            rule.removeProperty(PageStyleKeys.SIZE);
            return;
        }
        double width = format.getWidth();
        double height = format.getHeight();
        rule.setPropertyValueAsString(PageStyleKeys.SIZE, width + "pt " + height + "pt");
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_TOP, format.getImageableY() + "pt");
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_LEFT, format.getImageableX() + "pt");
        double marginRight = width - format.getImageableX() - format.getImageableWidth();
        double marginBottom = height - format.getImageableY() - format.getImageableHeight();
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_BOTTOM, marginBottom + "pt");
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_RIGHT, marginRight + "pt");
    }

    public static PageFormat getPageFormat(CSSPageRule rule, int resolution) {
        CSSValue sizeValue = rule.getPropertyCSSValue(PageStyleKeys.SIZE);
        if (!(sizeValue instanceof CSSValuePair)) {
            return null;
        }
        CSSValuePair sizePair = (CSSValuePair)sizeValue;
        CSSValue firstValue = sizePair.getFirstValue();
        CSSValue secondValue = sizePair.getSecondValue();
        double width = StyleSheetUtility.convertLengthToDouble(firstValue, resolution);
        double height = StyleSheetUtility.convertLengthToDouble(secondValue, resolution);
        if (width == 0.0 || height == 0.0) {
            return null;
        }
        double marginLeft = StyleSheetUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_LEFT), resolution);
        double marginTop = StyleSheetUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_TOP), resolution);
        double marginRight = StyleSheetUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_RIGHT), resolution);
        double marginBottom = StyleSheetUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_BOTTOM), resolution);
        if (width < height) {
            Paper p = new Paper();
            p.setSize(width, height);
            p.setImageableArea(marginLeft, marginTop, width - marginLeft - marginRight, height - marginTop - marginBottom);
            PageFormat pageFormat = new PageFormat();
            pageFormat.setPaper(p);
            pageFormat.setOrientation(1);
            return pageFormat;
        }
        Paper p = new Paper();
        p.setSize(height, width);
        p.setImageableArea(marginLeft, marginTop, width - marginLeft - marginRight, height - marginTop - marginBottom);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(p);
        pageFormat.setOrientation(0);
        return pageFormat;
    }

    public static strictfp double convertLengthToDouble(CSSValue rawValue, int resolution) {
        if (!(rawValue instanceof CSSNumericValue)) {
            return 0.0;
        }
        CSSNumericValue value = (CSSNumericValue)rawValue;
        if (CSSNumericType.PT.equals(value.getType())) {
            return value.getValue();
        }
        if (CSSNumericType.PC.equals(value.getType())) {
            return value.getValue() / 12.0;
        }
        if (CSSNumericType.INCH.equals(value.getType())) {
            return value.getValue() / 72.0;
        }
        if (CSSNumericType.CM.equals(value.getType())) {
            return value.getValue() * 100.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.MM.equals(value.getType())) {
            return value.getValue() * 10.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.PX.equals(value.getType())) {
            if (resolution <= 0) {
                return value.getValue();
            }
            return value.getValue() * 72.0 / (double)resolution;
        }
        return 0.0;
    }

    public static strictfp double convertFontSizeToDouble(CSSValue rawValue, int resolution, LayoutElement baseElement) {
        if (!(rawValue instanceof CSSNumericValue)) {
            return 0.0;
        }
        CSSNumericValue value = (CSSNumericValue)rawValue;
        if (CSSNumericType.PT.equals(value.getType())) {
            return value.getValue();
        }
        if (CSSNumericType.PC.equals(value.getType())) {
            return value.getValue() / 12.0;
        }
        if (CSSNumericType.INCH.equals(value.getType())) {
            return value.getValue() / 72.0;
        }
        if (CSSNumericType.CM.equals(value.getType())) {
            return value.getValue() * 100.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.MM.equals(value.getType())) {
            return value.getValue() * 10.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.PX.equals(value.getType())) {
            if (resolution <= 0) {
                return value.getValue();
            }
            return value.getValue() * 72.0 / (double)resolution;
        }
        if (baseElement != null) {
            if (CSSNumericType.EM.equals(value.getType())) {
                CSSValue baseVal = baseElement.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
                return value.getValue() * StyleSheetUtility.convertLengthToDouble(baseVal, resolution);
            }
            if (CSSNumericType.EX.equals(value.getType())) {
                CSSValue baseVal = baseElement.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
                return value.getValue() * StyleSheetUtility.convertLengthToDouble(baseVal, resolution) * 0.58;
            }
            if (CSSNumericType.PERCENTAGE.equals(value.getType())) {
                CSSValue baseVal = baseElement.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
                return value.getValue() * StyleSheetUtility.convertLengthToDouble(baseVal, resolution) / 100.0;
            }
        }
        return 0.0;
    }

    public static strictfp CSSValue convertFontSize(CSSValue rawValue, int resolution, LayoutElement baseElement) {
        if (!(rawValue instanceof CSSNumericValue)) {
            return rawValue;
        }
        CSSNumericValue value = (CSSNumericValue)rawValue;
        if (baseElement != null) {
            CSSValue baseVal = baseElement.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
            if (!(baseVal instanceof CSSNumericValue)) {
                return CSSNumericValue.ZERO_LENGTH;
            }
            CSSNumericValue baseNValue = (CSSNumericValue)baseVal;
            if (CSSNumericType.EM.equals(value.getType())) {
                return CSSNumericValue.createValue(baseNValue.getNumericType(), value.getValue() * baseNValue.getValue());
            }
            if (CSSNumericType.EX.equals(value.getType())) {
                return CSSNumericValue.createValue(baseNValue.getNumericType(), value.getValue() * baseNValue.getValue() * 0.58);
            }
            if (CSSNumericType.PERCENTAGE.equals(value.getType())) {
                return CSSNumericValue.createValue(baseNValue.getNumericType(), value.getValue() * baseNValue.getValue() / 100.0);
            }
        }
        return rawValue;
    }

    public static strictfp CSSNumericValue convertLength(CSSValue rawValue, CSSNumericValue basePercentage, LayoutElement baseElement) {
        if (!(rawValue instanceof CSSNumericValue)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        CSSNumericValue value = (CSSNumericValue)rawValue;
        if (CSSNumericType.PERCENTAGE.equals(value.getType())) {
            return CSSNumericValue.createValue(basePercentage.getNumericType(), value.getValue() * basePercentage.getValue() / 100.0);
        }
        if (baseElement != null) {
            CSSValue baseVal = baseElement.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
            if (!(baseVal instanceof CSSNumericValue)) {
                return CSSNumericValue.ZERO_LENGTH;
            }
            CSSNumericValue baseNValue = (CSSNumericValue)baseVal;
            if (CSSNumericType.EM.equals(value.getType())) {
                return CSSNumericValue.createValue(baseNValue.getNumericType(), value.getValue() * baseNValue.getValue());
            }
            if (CSSNumericType.EX.equals(value.getType())) {
                return CSSNumericValue.createValue(baseNValue.getNumericType(), value.getValue() * baseNValue.getValue() * 0.58);
            }
            return baseNValue;
        }
        return CSSNumericValue.ZERO_LENGTH;
    }
}

