/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.model.StyleKey;

public class StyleKeyRegistry {
    private static final Log logger = LogFactory.getLog(StyleKeyRegistry.class);
    private static StyleKeyRegistry registry;
    private LinkedMap knownStyleKeys = new LinkedMap();
    private boolean locked;

    public static synchronized StyleKeyRegistry getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("You have to boot LibCSS to make all style-keys known");
        }
        return registry;
    }

    public static void performBoot() {
        if (registry != null) {
            return;
        }
        registry = new StyleKeyRegistry();
        registry.registerDefaults();
        StyleKeyRegistry.registry.locked = true;
    }

    private StyleKeyRegistry() {
    }

    public StyleKey findKeyByName(String name) {
        return (StyleKey)this.knownStyleKeys.get((Object)name);
    }

    public int getKeyCount() {
        return this.knownStyleKeys.size();
    }

    public synchronized void registerDefaults() {
        if (this.locked) {
            throw new IllegalStateException("All StyleKeys must be registered during the bootup. The registry is locked now.");
        }
        Configuration config = LibCssBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys("org.pentaho.reporting.libraries.css.stylekeys.");
        ClassLoader classLoader = ObjectUtilities.getClassLoader(StyleKeyRegistry.class);
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                String className = config.getConfigProperty(key);
                Class<?> c = Class.forName(className, false, classLoader);
                this.registerClass(c);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NullPointerException e) {}
        }
    }

    private void registerClass(Class c) {
        try {
            Field[] fields = c.getFields();
            for (int i = 0; i < fields.length; ++i) {
                StyleKey value;
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
                if (!Modifier.isFinal(modifiers)) {
                    logger.warn((Object)("Invalid implementation: StyleKeys should be 'public static final': " + c));
                }
                if (!field.getType().isAssignableFrom(StyleKey.class) || (value = (StyleKey)field.get(null)) != null) continue;
                logger.warn((Object)("Invalid implementation: StyleKeys fields must not be null: " + c));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public synchronized StyleKey createKey(String name, boolean trans, boolean inherited, int validity) {
        StyleKey existingKey = this.findKeyByName(name);
        if (existingKey != null) {
            return existingKey;
        }
        if (this.locked) {
            throw new IllegalStateException("All StyleKeys must be registered during the bootup. The registry is locked now.");
        }
        StyleKey createdKey = new StyleKey(name, trans, inherited, this.knownStyleKeys.size(), validity);
        this.knownStyleKeys.put((Object)name, (Object)createdKey);
        return createdKey;
    }

    public synchronized StyleKey[] getKeys() {
        return (StyleKey[])this.knownStyleKeys.values((Object[])new StyleKey[this.knownStyleKeys.size()]);
    }

    public synchronized StyleKey[] getKeys(StyleKey[] input) {
        return (StyleKey[])this.knownStyleKeys.values((Object[])input);
    }
}

