/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.namespace;

import java.util.StringTokenizer;
import org.pentaho.reporting.libraries.css.namespace.NamespaceDefinition;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class DefaultNamespaceDefinition
implements NamespaceDefinition {
    private String uri;
    private String[] classAttribute;
    private String[] styleAttribute;
    private ResourceKey defaultStyleSheet;
    private String preferredPrefix;

    public DefaultNamespaceDefinition(String uri, ResourceKey defaultStyleSheet, String classAttribute, String styleAttribute, String preferredPrefix) {
        if (uri == null) {
            throw new NullPointerException();
        }
        this.uri = uri;
        this.defaultStyleSheet = defaultStyleSheet;
        this.classAttribute = this.buildArray(classAttribute);
        this.styleAttribute = this.buildArray(styleAttribute);
        this.preferredPrefix = preferredPrefix;
    }

    private String[] buildArray(String attr) {
        if (attr == null) {
            return new String[0];
        }
        StringTokenizer strtok = new StringTokenizer(attr);
        int size = strtok.countTokens();
        String[] retval = new String[size];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = strtok.nextToken();
        }
        return retval;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String[] getClassAttribute(String element) {
        return (String[])this.classAttribute.clone();
    }

    @Override
    public String[] getStyleAttribute(String element) {
        return (String[])this.styleAttribute.clone();
    }

    @Override
    public ResourceKey getDefaultStyleSheetLocation() {
        return this.defaultStyleSheet;
    }

    @Override
    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }
}

