/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser;

import java.io.IOException;
import org.pentaho.reporting.libraries.css.model.CSSDeclarationRule;
import org.pentaho.reporting.libraries.css.model.CSSStyleRule;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.parser.CSSParserContext;
import org.pentaho.reporting.libraries.css.parser.CSSParserFactory;
import org.pentaho.reporting.libraries.css.parser.CSSParserInstantiationException;
import org.pentaho.reporting.libraries.css.parser.StyleSheetHandler;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

public class StyleRuleFactory
implements ResourceFactory {
    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        try {
            long version;
            ResourceKey key;
            Parser parser = CSSParserFactory.getInstance().createCSSParser();
            if (context == null) {
                key = data.getKey();
                version = data.getVersion(manager);
            } else {
                key = context;
                version = -1L;
            }
            StyleSheetHandler handler = new StyleSheetHandler();
            handler.init(StyleKeyRegistry.getRegistry(), manager, key, version, null);
            parser.setDocumentHandler((DocumentHandler)handler);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(data.getResourceAsStream(manager));
            handler.initParseContext(inputSource);
            handler.setStyleRule(new CSSStyleRule(null, null));
            parser.parseStyleDeclaration(inputSource);
            DependencyCollector dependencies = handler.getDependencies();
            if (context != null) {
                dependencies.add(data.getKey(), data.getVersion(manager));
            }
            CSSParserContext.getContext().destroy();
            CSSDeclarationRule styleRule = handler.getStyleRule();
            if (styleRule == null) {
                throw new ResourceCreationException("Damn, the style rule is null");
            }
            return new CompoundResource(data.getKey(), dependencies, (Object)styleRule, this.getFactoryType());
        }
        catch (CSSParserInstantiationException e) {
            throw new ResourceCreationException("Failed to parse the stylesheet.");
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to load the stylesheet.");
        }
    }

    public Class getFactoryType() {
        return CSSDeclarationRule.class;
    }

    public void initializeDefaults() {
    }
}

