/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class BorderRadiusReadHandler
implements CSSValueReadHandler,
CSSCompoundValueReadHandler {
    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        CSSNumericValue secondValue;
        CSSNumericValue firstValue = CSSValueFactory.createLengthValue(value);
        if (firstValue == null) {
            return null;
        }
        if ((value = value.getNextLexicalUnit()) == null) {
            secondValue = firstValue;
        } else {
            secondValue = CSSValueFactory.createLengthValue(value);
            if (secondValue == null) {
                return null;
            }
        }
        return new CSSValuePair(firstValue, secondValue);
    }

    @Override
    public Map createValues(LexicalUnit unit) {
        CSSValue value = this.createValue(null, unit);
        if (value == null) {
            return null;
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(BorderStyleKeys.BORDER_TOP_RIGHT_RADIUS, value);
        map.put(BorderStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS, value);
        map.put(BorderStyleKeys.BORDER_BOTTOM_LEFT_RADIUS, value);
        map.put(BorderStyleKeys.BORDER_TOP_LEFT_RADIUS, value);
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_RIGHT_RADIUS, BorderStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS, BorderStyleKeys.BORDER_BOTTOM_LEFT_RADIUS, BorderStyleKeys.BORDER_TOP_LEFT_RADIUS};
    }
}

