/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.box;

import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.stylehandler.OneOfConstantsReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSAutoValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class FitPositionReadHandler
extends OneOfConstantsReadHandler {
    public static final CSSNumericValue CENTER = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 50.0);
    public static final CSSNumericValue TOP = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue LEFT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue BOTTOM = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);
    public static final CSSNumericValue RIGHT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);

    public FitPositionReadHandler() {
        super(false);
    }

    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        String stringValue;
        if (value.getLexicalUnitType() == 35 && (stringValue = value.getStringValue()).equalsIgnoreCase("auto")) {
            return CSSAutoValue.getInstance();
        }
        CSSValue firstPosition = this.parseFirstPosition(value);
        if (firstPosition == null) {
            return null;
        }
        CSSValue secondPosition = this.parseSecondPosition(value = value.getNextLexicalUnit(), firstPosition);
        if (secondPosition == null) {
            return null;
        }
        return this.createResultList(firstPosition, secondPosition);
    }

    protected CSSValue parseFirstPosition(LexicalUnit value) {
        if (value == null) {
            return null;
        }
        if (value.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(value.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(value.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(value.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(value.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(value.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(value)) {
            return CSSValueFactory.createLengthValue(value);
        }
        return null;
    }

    protected CSSValuePair createResultList(CSSValue firstPosition, CSSValue secondPosition) {
        if (firstPosition == TOP || firstPosition == BOTTOM) {
            return new CSSValuePair(secondPosition, firstPosition);
        }
        if (secondPosition == LEFT || secondPosition == RIGHT) {
            return new CSSValuePair(secondPosition, firstPosition);
        }
        return new CSSValuePair(firstPosition, secondPosition);
    }

    protected CSSValue parseSecondPosition(LexicalUnit value, CSSValue firstValue) {
        if (value == null) {
            return CENTER;
        }
        if (value.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(value.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(value.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(value.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(value.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(value.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(value)) {
            return CSSValueFactory.createLengthValue(value);
        }
        return CENTER;
    }
}

