/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.box;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.box.BoxStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.AbstractWidthReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class PaddingReadHandler
extends AbstractWidthReadHandler
implements CSSCompoundValueReadHandler {
    public PaddingReadHandler() {
        super(true, false);
    }

    @Override
    public Map createValues(LexicalUnit unit) {
        CSSValue leftWidth;
        CSSValue bottomWidth;
        CSSValue rightWidth;
        CSSValue topWidth = this.parseWidth(unit);
        if (topWidth == null) {
            return null;
        }
        if ((unit = unit.getNextLexicalUnit()) == null) {
            rightWidth = topWidth;
        } else {
            rightWidth = this.parseWidth(unit);
            if (rightWidth == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            bottomWidth = topWidth;
        } else {
            bottomWidth = this.parseWidth(unit);
            if (bottomWidth == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            leftWidth = rightWidth;
        } else {
            leftWidth = this.parseWidth(unit);
            if (leftWidth == null) {
                return null;
            }
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(BoxStyleKeys.PADDING_TOP, topWidth);
        map.put(BoxStyleKeys.PADDING_RIGHT, rightWidth);
        map.put(BoxStyleKeys.PADDING_BOTTOM, bottomWidth);
        map.put(BoxStyleKeys.PADDING_LEFT, leftWidth);
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BoxStyleKeys.PADDING_TOP, BoxStyleKeys.PADDING_RIGHT, BoxStyleKeys.PADDING_BOTTOM, BoxStyleKeys.PADDING_LEFT};
    }
}

