/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.content;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.css.keys.content.ContentValues;
import org.pentaho.reporting.libraries.css.keys.list.ListStyleTypeGlyphs;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.stylehandler.OneOfConstantsReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSAttrFunction;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSStringType;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;
import org.w3c.css.sac.LexicalUnit;

public class ContentReadHandler
extends OneOfConstantsReadHandler {
    public ContentReadHandler() {
        super(false);
        this.addValue(ContentValues.CLOSE_QUOTE);
        this.addValue(ContentValues.CONTENTS);
        this.addValue(ContentValues.DOCUMENT_URL);
        this.addValue(ContentValues.ENDNOTE);
        this.addValue(ContentValues.FOOTNOTE);
        this.addValue(ContentValues.LISTITEM);
        this.addValue(ContentValues.NO_CLOSE_QUOTE);
        this.addValue(ContentValues.NO_OPEN_QUOTE);
        this.addValue(ContentValues.OPEN_QUOTE);
        this.addValue(ContentValues.SECTIONNOTE);
        this.addValue(ListStyleTypeGlyphs.BOX);
        this.addValue(ListStyleTypeGlyphs.CHECK);
        this.addValue(ListStyleTypeGlyphs.CIRCLE);
        this.addValue(ListStyleTypeGlyphs.DIAMOND);
        this.addValue(ListStyleTypeGlyphs.DISC);
        this.addValue(ListStyleTypeGlyphs.HYPHEN);
        this.addValue(ListStyleTypeGlyphs.SQUARE);
    }

    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        CSSValue[] values;
        if (value.getLexicalUnitType() == 35) {
            String text = value.getStringValue();
            if (ContentValues.NONE.getCSSText().equals(text)) {
                return ContentValues.NONE;
            }
            if (ContentValues.INHIBIT.getCSSText().equals(text)) {
                return ContentValues.INHIBIT;
            }
            if (ContentValues.NORMAL.getCSSText().equals(text)) {
                return ContentValues.NORMAL;
            }
        }
        ArrayList<CSSValueList> contents = new ArrayList<CSSValueList>();
        ArrayList<CSSValue> contentList = new ArrayList<CSSValue>();
        while (value != null) {
            if (value.getLexicalUnitType() == 35) {
                CSSValue o = this.lookupValue(value);
                if (o == null) {
                    return null;
                }
                contentList.add(o);
            } else if (value.getLexicalUnitType() == 36) {
                contentList.add(new CSSStringValue(CSSStringType.STRING, value.getStringValue()));
            } else if (value.getLexicalUnitType() == 24) {
                CSSStringValue uriValue = CSSValueFactory.createUriValue(value);
                if (uriValue == null) {
                    return null;
                }
                contentList.add(uriValue);
            } else if (value.getLexicalUnitType() == 41 || value.getLexicalUnitType() == 25 || value.getLexicalUnitType() == 26) {
                CSSFunctionValue functionValue = CSSValueFactory.parseFunction(value);
                if (functionValue == null) {
                    return null;
                }
                contentList.add(functionValue);
            } else if (value.getLexicalUnitType() == 37) {
                CSSAttrFunction attrFn = CSSValueFactory.parseAttrFunction(value);
                if (attrFn == null) {
                    return null;
                }
                contentList.add(attrFn);
            } else if (value.getLexicalUnitType() == 0) {
                values = contentList.toArray(new CSSValue[contentList.size()]);
                contents.add(new CSSValueList(values));
                contentList.clear();
            }
            value = value.getNextLexicalUnit();
        }
        values = contentList.toArray(new CSSValue[contentList.size()]);
        contents.add(new CSSValueList(values));
        return new CSSValueList(contents);
    }
}

