/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.line;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.line.AlignmentBaseline;
import org.pentaho.reporting.libraries.css.keys.line.BaselineShift;
import org.pentaho.reporting.libraries.css.keys.line.LineStyleKeys;
import org.pentaho.reporting.libraries.css.keys.line.VerticalAlign;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.stylehandler.OneOfConstantsReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSAutoValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class VerticalAlignReadHandler
extends OneOfConstantsReadHandler
implements CSSCompoundValueReadHandler {
    public VerticalAlignReadHandler() {
        super(true);
        this.addValue(VerticalAlign.BASELINE);
        this.addValue(VerticalAlign.BOTTOM);
        this.addValue(VerticalAlign.CENTRAL);
        this.addValue(VerticalAlign.MIDDLE);
        this.addValue(VerticalAlign.SUB);
        this.addValue(VerticalAlign.SUPER);
        this.addValue(VerticalAlign.TEXT_BOTTOM);
        this.addValue(VerticalAlign.TEXT_TOP);
        this.addValue(VerticalAlign.USE_SCRIPT);
        this.addValue(VerticalAlign.TOP);
    }

    @Override
    protected CSSValue lookupValue(LexicalUnit value) {
        CSSValue constant = super.lookupValue(value);
        if (constant != null) {
            return constant;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        return CSSValueFactory.createLengthValue(value);
    }

    @Override
    public Map createValues(LexicalUnit unit) {
        CSSValue value = this.lookupValue(unit);
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(LineStyleKeys.VERTICAL_ALIGN, value);
        map.put(LineStyleKeys.ALIGNMENT_ADJUST, CSSAutoValue.getInstance());
        map.put(LineStyleKeys.DOMINANT_BASELINE, CSSAutoValue.getInstance());
        if (CSSAutoValue.getInstance().equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BASELINE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.BASELINE.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.BOTTOM.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.AFTER_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.CENTRAL.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.CENTRAL);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.MIDDLE.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.MIDDLE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.SUB.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.SUB);
        } else if (VerticalAlign.SUPER.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.SUPER);
        } else if (VerticalAlign.TEXT_BOTTOM.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.TEXT_AFTER_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.TEXT_TOP.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.TEXT_BEFORE_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.TOP.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BEFORE_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.USE_SCRIPT.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, CSSAutoValue.getInstance());
        } else {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BASELINE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
            map.put(LineStyleKeys.ALIGNMENT_ADJUST, value);
        }
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{LineStyleKeys.VERTICAL_ALIGN, LineStyleKeys.ALIGNMENT_BASELINE, LineStyleKeys.DOMINANT_BASELINE, LineStyleKeys.ALIGNMENT_ADJUST, LineStyleKeys.BASELINE_SHIFT};
    }
}

