/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function.content;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.ContentFunction;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionUtilities;
import org.pentaho.reporting.libraries.css.resolver.tokens.ContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.ResourceContentToken;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSResourceValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.Resource;

public class UrlValueFunction
implements ContentFunction {
    @Override
    public ContentToken evaluate(DocumentContext layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length != 1) {
            throw new FunctionEvaluationException();
        }
        CSSValue value = FunctionUtilities.resolveParameter(layoutProcess, element, params[0]);
        if (value instanceof CSSResourceValue) {
            CSSResourceValue cssResourceValue = (CSSResourceValue)value;
            Resource resource = cssResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (!(value instanceof CSSStringValue)) {
            throw new FunctionEvaluationException("Not even remotely an URI: " + value);
        }
        CSSStringValue strval = (CSSStringValue)value;
        CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, strval.getValue());
        Resource resource = cssResourceValue.getValue();
        return new ResourceContentToken(resource);
    }
}

