/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function.values;

import java.awt.Color;
import java.net.URL;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionUtilities;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;
import org.pentaho.reporting.libraries.css.util.ColorUtil;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSRawValue;
import org.pentaho.reporting.libraries.css.values.CSSResourceValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class AttrValueFunction
implements StyleValueFunction {
    @Override
    public boolean isAutoResolveable() {
        return true;
    }

    @Override
    public CSSValue evaluate(DocumentContext layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException("The parsed attr() function needs at least two parameters.");
        }
        String namespace = FunctionUtilities.resolveString(layoutProcess, element, params[0]);
        String name = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        String type = null;
        if (params.length >= 3) {
            type = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
        }
        if (namespace == null || "".equals(namespace) || "*".equals(namespace)) {
            Object value = element.getAttribute(element.getNamespace(), name);
            return this.convertValue(layoutProcess, value, type);
        }
        Object value = element.getAttribute(namespace, name);
        return this.convertValue(layoutProcess, value, type);
    }

    private CSSValue convertValue(DocumentContext layoutProcess, Object value, String type) throws FunctionEvaluationException {
        if (value instanceof CSSValue) {
            throw new FunctionEvaluationException();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if ("length".equals(type)) {
                return FunctionUtilities.parseNumberValue(strVal);
            }
            if ("url".equals(type)) {
                return FunctionUtilities.loadResource(layoutProcess, strVal);
            }
            if ("color".equals(type)) {
                CSSValue colorValue = ColorUtil.parseColor(strVal);
                if (colorValue == null) {
                    throw new FunctionEvaluationException();
                }
                return colorValue;
            }
            return FunctionUtilities.parseValue(layoutProcess, strVal);
        }
        if (value instanceof URL) {
            return FunctionUtilities.loadResource(layoutProcess, value);
        }
        if (value instanceof Resource) {
            return new CSSResourceValue((Resource)value);
        }
        if (value instanceof ResourceKey) {
            return FunctionUtilities.loadResource(layoutProcess, value);
        }
        if (value instanceof Number) {
            return FunctionUtilities.parseNumberValue(value.toString(), type);
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            return new CSSColorValue(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return new CSSRawValue(value);
    }
}

