/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function.values;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionUtilities;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class RgbValueFunction
implements StyleValueFunction {
    protected int validateParameter(CSSValue value) throws FunctionEvaluationException {
        CSSNumericValue nval;
        if (value instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)value;
            nval = FunctionUtilities.parseNumberValue(strVal.getValue());
        } else {
            if (!(value instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            nval = (CSSNumericValue)value;
        }
        if (nval.getType().equals(CSSNumericType.NUMBER)) {
            return (int)(nval.getValue() % 256.0);
        }
        if (nval.getType().equals(CSSNumericType.PERCENTAGE)) {
            return (int)(nval.getValue() * 256.0 / 100.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    @Override
    public boolean isAutoResolveable() {
        return true;
    }

    @Override
    public CSSValue evaluate(DocumentContext layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] values = function.getParameters();
        if (values.length == 3) {
            int redValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            int greenValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            int blueValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            return new CSSColorValue(redValue, greenValue, blueValue);
        }
        if (values.length == 4) {
            int redValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            int greenValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            int blueValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            int alphaValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[3]));
            return new CSSColorValue(redValue, greenValue, blueValue, alphaValue);
        }
        throw new FunctionEvaluationException("Expected either three or four parameters.");
    }
}

