/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.fonts;

import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutOutputMetaData;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontFamilyValues;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;

public class FontFamilyResolveHandler
extends ConstantsResolveHandler {
    public FontFamilyResolveHandler() {
        this.addNormalizeValue(FontFamilyValues.CURSIVE);
        this.addNormalizeValue(FontFamilyValues.FANTASY);
        this.addNormalizeValue(FontFamilyValues.MONOSPACE);
        this.addNormalizeValue(FontFamilyValues.SANS_SERIF);
        this.addNormalizeValue(FontFamilyValues.SERIF);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_WEIGHT, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        LayoutOutputMetaData outputMetaData = process.getOutputMetaData();
        CSSValue cssValue = layoutContext.getValue(key);
        if (cssValue instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)cssValue;
            for (int i = 0; i < list.getLength(); ++i) {
                CSSValue item = list.getItem(i);
                if (item instanceof CSSConstant) {
                    CSSConstant c = (CSSConstant)this.lookupValue((CSSConstant)item);
                    CSSValue family = outputMetaData.getNormalizedFontFamilyName(c);
                    if (family != null) {
                        layoutContext.setValue(key, family);
                        return;
                    }
                    DebugLog.log((Object)"Invalid state after setting predefined font family.");
                    continue;
                }
                if (!(item instanceof CSSStringValue)) continue;
                CSSStringValue sval = (CSSStringValue)item;
                CSSValue value = process.getOutputMetaData().getNormalizedFontFamilyName(sval);
                if (value == null) continue;
                layoutContext.setValue(key, value);
                return;
            }
        } else if (cssValue instanceof CSSConstant && FontFamilyValues.NONE.equals(cssValue)) {
            return;
        }
        layoutContext.setValue(key, outputMetaData.getDefaultFontFamily());
    }
}

