/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.fonts;

import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutOutputMetaData;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.dom.OutputProcessorFeature;
import org.pentaho.reporting.libraries.css.keys.font.FontSizeConstant;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.font.RelativeFontSize;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class FontSizeResolveHandler
extends ConstantsResolveHandler {
    private static final String SIZE_FACTOR_PREFIX = "org.jfree.layouting.defaults.FontSizeFactor.";
    private double fontSize = this.parseDouble("org.jfree.layouting.defaults.FontSize", 12.0);
    private CSSNumericValue[] predefinedSizes = new CSSNumericValue[7];
    private double[] predefinedScalingFactors;

    public FontSizeResolveHandler() {
        this.predefinedSizes[0] = this.computePredefinedSize(FontSizeConstant.XX_SMALL);
        this.predefinedSizes[1] = this.computePredefinedSize(FontSizeConstant.X_SMALL);
        this.predefinedSizes[2] = this.computePredefinedSize(FontSizeConstant.SMALL);
        this.predefinedSizes[3] = this.computePredefinedSize(FontSizeConstant.MEDIUM);
        this.predefinedSizes[4] = this.computePredefinedSize(FontSizeConstant.LARGE);
        this.predefinedSizes[5] = this.computePredefinedSize(FontSizeConstant.X_LARGE);
        this.predefinedSizes[6] = this.computePredefinedSize(FontSizeConstant.XX_LARGE);
        this.predefinedScalingFactors = new double[7];
        this.predefinedScalingFactors[0] = this.computePredefinedScalingFactor(FontSizeConstant.XX_SMALL);
        this.predefinedScalingFactors[1] = this.computePredefinedScalingFactor(FontSizeConstant.X_SMALL);
        this.predefinedScalingFactors[2] = this.computePredefinedScalingFactor(FontSizeConstant.SMALL);
        this.predefinedScalingFactors[3] = this.computePredefinedScalingFactor(FontSizeConstant.MEDIUM);
        this.predefinedScalingFactors[4] = this.computePredefinedScalingFactor(FontSizeConstant.LARGE);
        this.predefinedScalingFactors[5] = this.computePredefinedScalingFactor(FontSizeConstant.X_LARGE);
        this.predefinedScalingFactors[6] = this.computePredefinedScalingFactor(FontSizeConstant.XX_LARGE);
        this.addValue(FontSizeConstant.XX_SMALL, this.predefinedSizes[0]);
        this.addValue(FontSizeConstant.X_SMALL, this.predefinedSizes[1]);
        this.addValue(FontSizeConstant.SMALL, this.predefinedSizes[2]);
        this.addValue(FontSizeConstant.MEDIUM, this.predefinedSizes[3]);
        this.addValue(FontSizeConstant.LARGE, this.predefinedSizes[4]);
        this.addValue(FontSizeConstant.X_LARGE, this.predefinedSizes[5]);
        this.addValue(FontSizeConstant.XX_LARGE, this.predefinedSizes[6]);
    }

    private CSSNumericValue computePredefinedSize(CSSConstant c) {
        String key = SIZE_FACTOR_PREFIX + c.getCSSText();
        double scaling = this.parseDouble(key, 100.0);
        return CSSNumericValue.createValue(CSSNumericType.PT, this.fontSize * scaling / 100.0);
    }

    private double computePredefinedScalingFactor(CSSConstant c) {
        String key = SIZE_FACTOR_PREFIX + c.getCSSText();
        return this.parseDouble(key, 100.0);
    }

    private double parseDouble(String configKey, double defaultValue) {
        String value = LibCssBoot.getInstance().getGlobalConfig().getConfigProperty(configKey);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        CSSValue resolvedValue;
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSConstant)) {
            return;
        }
        LayoutOutputMetaData metaData = process.getOutputMetaData();
        int resolution = (int)metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
        CSSConstant constant = (CSSConstant)value;
        LayoutElement parent = currentNode.getParentLayoutElement();
        if (parent != null) {
            CSSValue parentFontSizeValue = parent.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
            double parentFontSize = StyleSheetUtility.convertLengthToDouble(parentFontSizeValue, resolution);
            if (RelativeFontSize.LARGER.equals(value)) {
                double scaleFactor = this.getScaleLargerFactor(parentFontSize);
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, scaleFactor));
                return;
            }
            if (RelativeFontSize.SMALLER.equals(value)) {
                double scaleFactor = this.getScaleSmallerFactor(parentFontSize);
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, scaleFactor));
                return;
            }
        } else {
            if (RelativeFontSize.LARGER.equals(value)) {
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 120.0));
                return;
            }
            if (RelativeFontSize.SMALLER.equals(value)) {
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 85.0));
                return;
            }
        }
        if ((resolvedValue = this.lookupValue(constant)) != null) {
            layoutContext.setValue(key, resolvedValue);
        }
    }

    public double getScaleLargerFactor(double parentSize) {
        for (int i = 0; i < this.predefinedSizes.length; ++i) {
            CSSNumericValue size = this.predefinedSizes[i];
            if (!(parentSize < size.getValue())) continue;
            return this.predefinedScalingFactors[i];
        }
        return this.predefinedScalingFactors[6];
    }

    public double getScaleSmallerFactor(double parentSize) {
        for (int i = this.predefinedSizes.length; i >= 0; --i) {
            CSSNumericValue size = this.predefinedSizes[i];
            if (!(parentSize > size.getValue())) continue;
            return this.predefinedScalingFactors[i];
        }
        return this.predefinedScalingFactors[0];
    }
}

