/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.fonts;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStretch;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class FontStretchResolveHandler
extends ConstantsResolveHandler {
    public FontStretchResolveHandler() {
        this.addNormalizeValue(FontStretch.CONDENSED);
        this.addNormalizeValue(FontStretch.EXPANDED);
        this.addNormalizeValue(FontStretch.EXTRA_CONDENSED);
        this.addNormalizeValue(FontStretch.EXTRA_EXPANDED);
        this.addNormalizeValue(FontStretch.NORMAL);
        this.addNormalizeValue(FontStretch.SEMI_CONDENSED);
        this.addNormalizeValue(FontStretch.SEMI_EXPANDED);
        this.addNormalizeValue(FontStretch.ULTRA_CONDENSED);
        this.addNormalizeValue(FontStretch.ULTRA_EXPANDED);
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        CSSConstant result;
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (FontStretch.WIDER.equals(value)) {
            CSSConstant parentStretch = this.queryParent(currentNode.getParentLayoutElement());
            result = FontStretch.getByOrder(FontStretch.getOrder(parentStretch) + 1);
        } else if (FontStretch.NARROWER.equals(value)) {
            CSSConstant parentStretch = this.queryParent(currentNode.getParentLayoutElement());
            result = FontStretch.getByOrder(FontStretch.getOrder(parentStretch) - 1);
        } else {
            CSSConstant stretch;
            result = value instanceof CSSConstant ? ((stretch = (CSSConstant)this.lookupValue((CSSConstant)value)) != null ? stretch : FontStretch.NORMAL) : FontStretch.NORMAL;
        }
        layoutContext.setValue(key, result);
    }

    private CSSConstant queryParent(LayoutElement parent) {
        if (parent == null) {
            return FontStretch.NORMAL;
        }
        CSSValue parentValue = parent.getLayoutStyle().getValue(FontStyleKeys.FONT_STRETCH);
        if (parentValue == null) {
            return FontStretch.NORMAL;
        }
        return FontStretch.getByOrder(FontStretch.getOrder(parentValue));
    }
}

