/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.fonts;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.font.FontWeight;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class FontWeightResolveHandler
implements ResolveHandler {
    private static final StyleKey[] EMPTY_KEYS = new StyleKey[0];

    @Override
    public StyleKey[] getRequiredStyles() {
        return EMPTY_KEYS;
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        int fontWeight;
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (FontWeight.BOLD.equals(value)) {
            fontWeight = 700;
        } else if (FontWeight.NORMAL.equals(value)) {
            fontWeight = 400;
        } else if (FontWeight.BOLDER.equals(value)) {
            int parentFontWeight = this.queryParent(currentNode.getParentLayoutElement());
            fontWeight = Math.max(900, parentFontWeight + 100);
        } else if (FontWeight.LIGHTER.equals(value)) {
            int parentFontWeight = this.queryParent(currentNode.getParentLayoutElement());
            fontWeight = Math.min(100, parentFontWeight - 100);
        } else {
            CSSNumericValue nval;
            fontWeight = value instanceof CSSNumericValue ? (!CSSNumericType.NUMBER.equals((nval = (CSSNumericValue)value).getType()) ? this.queryParent(currentNode.getParentLayoutElement()) : (int)nval.getValue()) : this.queryParent(currentNode.getParentLayoutElement());
        }
        layoutContext.setValue(FontStyleKeys.FONT_WEIGHT, CSSNumericValue.createValue(CSSNumericType.NUMBER, fontWeight));
    }

    private int queryParent(LayoutElement parent) {
        if (parent == null) {
            return 400;
        }
        CSSValue value = parent.getLayoutStyle().getValue(FontStyleKeys.FONT_WEIGHT);
        if (!(value instanceof CSSNumericValue)) {
            throw new IllegalStateException("Parent was not resolved correctly");
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (!CSSNumericType.NUMBER.equals(nval.getType())) {
            throw new IllegalStateException("Parent was not resolved correctly");
        }
        return (int)nval.getValue();
    }
}

