/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.position;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.box.BoxStyleKeys;
import org.pentaho.reporting.libraries.css.keys.box.DisplayModel;
import org.pentaho.reporting.libraries.css.keys.box.DisplayRole;
import org.pentaho.reporting.libraries.css.keys.box.Floating;
import org.pentaho.reporting.libraries.css.keys.positioning.Position;
import org.pentaho.reporting.libraries.css.keys.positioning.PositioningStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class PositionResolveHandler
extends ConstantsResolveHandler {
    public PositionResolveHandler() {
        this.addNormalizeValue(Position.ABSOLUTE);
        this.addNormalizeValue(Position.FIXED);
        this.addNormalizeValue(Position.RELATIVE);
        this.addNormalizeValue(Position.STATIC);
        this.setFallback(Position.STATIC);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_MODEL};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue displayModel = layoutContext.getValue(BoxStyleKeys.DISPLAY_MODEL);
        if (DisplayRole.NONE.equals(displayModel)) {
            layoutContext.setValue(PositioningStyleKeys.POSITION, Position.STATIC);
            return;
        }
        CSSValue rawValue = layoutContext.getValue(key);
        if (rawValue instanceof CSSFunctionValue) {
            CSSFunctionValue function = (CSSFunctionValue)rawValue;
            if ("running".equals(function.getFunctionName())) {
                layoutContext.setValue(BoxStyleKeys.DISPLAY_MODEL, DisplayModel.BLOCK_INSIDE);
                layoutContext.setValue(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.BLOCK);
                return;
            }
            layoutContext.setValue(PositioningStyleKeys.POSITION, Position.STATIC);
            return;
        }
        CSSConstant value = (CSSConstant)this.resolveValue(process, currentNode, key);
        layoutContext.setValue(PositioningStyleKeys.POSITION, value);
        if (Position.ABSOLUTE.equals(value) || Position.FIXED.equals(value)) {
            layoutContext.setValue(BoxStyleKeys.DISPLAY_MODEL, DisplayModel.BLOCK_INSIDE);
            layoutContext.setValue(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.BLOCK);
            layoutContext.setValue(BoxStyleKeys.FLOAT, Floating.NONE);
        }
    }
}

