/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.percentages.lines;

import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutOutputMetaData;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.dom.OutputProcessorFeature;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.line.LineHeight;
import org.pentaho.reporting.libraries.css.keys.line.LineStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class LineHeightResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_SIZE_ADJUST};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        double factor;
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (LineHeight.NONE.equals(value)) {
            this.handleNone(process, currentNode);
            return;
        }
        if (LineHeight.NORMAL.equals(value)) {
            this.handleNormal(process, currentNode);
            return;
        }
        if (!(value instanceof CSSNumericValue)) {
            this.handleNormal(process, currentNode);
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (this.isLengthValue(nval)) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, nval);
            return;
        }
        if (nval.getType().equals(CSSNumericType.PERCENTAGE)) {
            factor = nval.getValue() / 100.0;
        } else if (nval.getType().equals(CSSNumericType.NUMBER)) {
            factor = nval.getValue();
        } else {
            this.handleNormal(process, currentNode);
            return;
        }
        LayoutOutputMetaData metaData = process.getOutputMetaData();
        int resolution = (int)metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
        double fontSize = StyleSheetUtility.convertLengthToDouble(value, resolution);
        layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * factor));
    }

    private boolean isLengthValue(CSSNumericValue nval) {
        CSSNumericType type = nval.getNumericType();
        return type.isLength();
    }

    private void handleNormal(DocumentContext process, LayoutElement currentNode) {
        LayoutOutputMetaData metaData;
        int resolution;
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(FontStyleKeys.FONT_SIZE);
        double fontSize = StyleSheetUtility.convertLengthToDouble(value, resolution = (int)(metaData = process.getOutputMetaData()).getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION));
        if (fontSize < 10.0) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * 1.2));
        } else if (fontSize < 24.0) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * 1.1));
        } else {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * 1.05));
        }
    }

    private void handleNone(DocumentContext process, LayoutElement currentNode) {
        double fontSize;
        LayoutElement parent = currentNode.getParentLayoutElement();
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        if (parent == null) {
            CSSValue value = layoutContext.getValue(FontStyleKeys.FONT_SIZE);
            LayoutOutputMetaData metaData = process.getOutputMetaData();
            int resolution = (int)metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            fontSize = StyleSheetUtility.convertLengthToDouble(value, resolution);
        } else {
            CSSValue value = parent.getLayoutStyle().getValue(FontStyleKeys.FONT_SIZE);
            LayoutOutputMetaData metaData = process.getOutputMetaData();
            int resolution = (int)metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            fontSize = StyleSheetUtility.convertLengthToDouble(value, resolution);
        }
        layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
    }
}

