/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.selectors;

import org.pentaho.reporting.libraries.css.selectors.AbstractSelector;
import org.pentaho.reporting.libraries.css.selectors.SelectorWeight;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.SimpleSelector;

public class CSSConditionalSelector
extends AbstractSelector
implements ConditionalSelector {
    private static final int ID_CONDITION = 0;
    private static final int ATTR_CONDITION = 1;
    private static final int OTHER_CONDITION = 2;
    private Condition condition;
    private SimpleSelector simpleSelector;

    public CSSConditionalSelector(SimpleSelector simpleSelector, Condition condition) {
        this.simpleSelector = simpleSelector;
        this.condition = condition;
    }

    @Override
    protected SelectorWeight createWeight() {
        int[] conditions = new int[3];
        this.countConditions(conditions, this.condition);
        return new SelectorWeight(0, conditions[0], conditions[1], conditions[2] + 1);
    }

    private void countConditions(int[] conditionCounter, Condition condition) {
        if (condition.getConditionType() == 5) {
            conditionCounter[0] = conditionCounter[0] + 1;
        } else if (condition instanceof AttributeCondition) {
            conditionCounter[1] = conditionCounter[1] + 1;
        } else if (condition instanceof CombinatorCondition) {
            CombinatorCondition c = (CombinatorCondition)condition;
            this.countConditions(conditionCounter, c.getFirstCondition());
            this.countConditions(conditionCounter, c.getSecondCondition());
        } else {
            conditionCounter[2] = conditionCounter[2] + 1;
        }
    }

    public SimpleSelector getSimpleSelector() {
        return this.simpleSelector;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public short getSelectorType() {
        return 0;
    }
}

