/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.values;

import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.values.CSSGenericType;
import org.pentaho.reporting.libraries.css.values.CSSType;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CSSValuePair
implements CSSValue {
    private CSSValue firstValue;
    private CSSValue secondValue;

    public CSSValuePair(CSSValue firstValue) {
        if (firstValue == null) {
            throw new NullPointerException();
        }
        this.firstValue = firstValue;
        this.secondValue = firstValue;
    }

    public CSSValuePair(CSSValue firstValue, CSSValue secondValue) {
        if (firstValue == null) {
            throw new NullPointerException();
        }
        if (secondValue == null) {
            throw new NullPointerException();
        }
        this.firstValue = firstValue;
        this.secondValue = secondValue;
    }

    public CSSValue getFirstValue() {
        return this.firstValue;
    }

    public CSSValue getSecondValue() {
        return this.secondValue;
    }

    @Override
    public String getCSSText() {
        return this.firstValue.getCSSText() + " " + this.secondValue.getCSSText();
    }

    public String toString() {
        return this.getCSSText();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CSSValuePair) {
            CSSValuePair that = (CSSValuePair)obj;
            return ObjectUtilities.equal((Object)this.firstValue, (Object)that.firstValue) && ObjectUtilities.equal((Object)this.secondValue, (Object)that.secondValue);
        }
        return false;
    }

    @Override
    public CSSType getType() {
        return CSSGenericType.GENERIC_TYPE;
    }
}

