/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Groups {
    private static final Log LOG = LogFactory.getLog(Groups.class);
    private final GroupMappingServiceProvider impl;
    private final Map<String, CachedGroups> userToGroupsMap = new ConcurrentHashMap<String, CachedGroups>();
    private final long cacheTimeout;
    private final long warningDeltaMs;
    private static Groups GROUPS = null;

    public Groups(Configuration conf) {
        this.impl = ReflectionUtils.newInstance(conf.getClass("hadoop.security.group.mapping", ShellBasedUnixGroupsMapping.class, GroupMappingServiceProvider.class), conf);
        this.cacheTimeout = conf.getLong("hadoop.security.groups.cache.secs", 300L) * 1000L;
        this.warningDeltaMs = conf.getLong("hadoop.security.groups.cache.warn.after.ms", 5000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Group mapping impl=" + this.impl.getClass().getName() + "; cacheTimeout=" + this.cacheTimeout + "; warningDeltaMs=" + this.warningDeltaMs));
        }
    }

    public List<String> getGroups(String user) throws IOException {
        CachedGroups groups = this.userToGroupsMap.get(user);
        long startMs = Time.monotonicNow();
        if (groups != null && groups.getTimestamp() + this.cacheTimeout > startMs) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning cached groups for '" + user + "'"));
            }
            return groups.getGroups();
        }
        List<String> groupList = this.impl.getGroups(user);
        long endMs = Time.monotonicNow();
        long deltaMs = endMs - startMs;
        UserGroupInformation.metrics.addGetGroups(deltaMs);
        if (deltaMs > this.warningDeltaMs) {
            LOG.warn((Object)("Potential performance problem: getGroups(user=" + user + ") " + "took " + deltaMs + " milliseconds."));
        }
        if ((groups = new CachedGroups(groupList, endMs)).getGroups().isEmpty()) {
            throw new IOException("No groups found for user " + user);
        }
        this.userToGroupsMap.put(user, groups);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning fetched groups for '" + user + "'"));
        }
        return groups.getGroups();
    }

    public void refresh() {
        LOG.info((Object)"clearing userToGroupsMap cache");
        try {
            this.impl.cacheGroupsRefresh();
        }
        catch (IOException e) {
            LOG.warn((Object)"Error refreshing groups cache", (Throwable)e);
        }
        this.userToGroupsMap.clear();
    }

    public void cacheGroupsAdd(List<String> groups) {
        try {
            this.impl.cacheGroupsAdd(groups);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error caching groups", (Throwable)e);
        }
    }

    public static Groups getUserToGroupsMappingService() {
        return Groups.getUserToGroupsMappingService(new Configuration());
    }

    public static synchronized Groups getUserToGroupsMappingService(Configuration conf) {
        if (GROUPS == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Creating new Groups object");
            }
            GROUPS = new Groups(conf);
        }
        return GROUPS;
    }

    private static class CachedGroups {
        final long timestamp;
        final List<String> groups;

        CachedGroups(List<String> groups, long timestamp) {
            this.groups = groups;
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

