/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalDataStoreException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.metrics.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.IndexAlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.apache.hadoop.hive.metastore.model.MDBPrivilege;
import org.apache.hadoop.hive.metastore.model.MGlobalPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MRole;
import org.apache.hadoop.hive.metastore.model.MRoleMap;
import org.apache.hadoop.hive.metastore.model.MTableColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MTablePrivilege;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static final Log LOG = LogFactory.getLog(HiveMetaStore.class);
    private static HadoopThriftAuthBridge.Server saslServer;

    public static void cancelDelegationToken(String tokenStrForm) throws IOException {
        saslServer.cancelDelegationToken(tokenStrForm);
    }

    public static String getDelegationToken(String renewer, String token_signature) throws IOException {
        return saslServer.getDelegationToken(renewer, token_signature);
    }

    public static String getDelegationToken(String renewer) throws IOException {
        return saslServer.getDelegationToken(renewer);
    }

    public static long renewDelegationToken(String tokenStrForm) throws IOException {
        return saslServer.renewDelegationToken(tokenStrForm);
    }

    public static void main(String[] args) {
        int port = 9083;
        if (args.length > 0) {
            port = new Integer(args[0]);
        }
        try {
            HiveMetaStore.startMetaStore(port, ShimLoader.getHadoopThriftAuthBridge());
        }
        catch (Throwable t) {
            HMSHandler.LOG.error((Object)"Metastore Thrift Server threw an exception. Exiting...");
            System.exit(1);
        }
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Throwable {
        try {
            TTransportFactory transFactory;
            HMSHandler handler = new HMSHandler("new db based metaserver");
            HiveConf conf = handler.getHiveConf();
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            boolean useSasl = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
            TServerSocketKeepAlive serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            TLoggingProcessor processor = new TLoggingProcessor(new ThriftHiveMetastore.Processor(handler));
            if (useSasl) {
                saslServer = bridge.createServer(conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_KEYTAB_FILE), conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL));
                saslServer.startDelegationTokenSecretManager((Configuration)conf);
                transFactory = saslServer.createTransportFactory();
                processor = saslServer.wrapProcessor((TProcessor)processor);
            } else {
                transFactory = new TTransportFactory();
            }
            TThreadPoolServer.Options options = new TThreadPoolServer.Options();
            options.minWorkerThreads = minWorkerThreads;
            options.maxWorkerThreads = maxWorkerThreads;
            TThreadPoolServer tServer = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, transFactory, transFactory, (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), options);
            HMSHandler.LOG.info((Object)("Started the new metaserver on port [" + port + "]..."));
            HMSHandler.LOG.info((Object)("Options.minWorkerThreads = " + options.minWorkerThreads));
            HMSHandler.LOG.info((Object)("Options.maxWorkerThreads = " + options.maxWorkerThreads));
            HMSHandler.LOG.info((Object)("TCP keepalive = " + tcpKeepAlive));
            tServer.serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)x));
            throw x;
        }
    }

    private static class TLoggingProcessor
    implements TProcessor {
        private static final ThreadLocal<InetAddress> remoteAddress = new ThreadLocal<InetAddress>(){

            @Override
            protected synchronized InetAddress initialValue() {
                return null;
            }
        };
        TProcessor wrapped;

        TLoggingProcessor(TProcessor wrapped) {
            this.wrapped = wrapped;
        }

        static InetAddress getRemoteAddress() {
            return remoteAddress.get();
        }

        public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
            if (TSocket.class.isAssignableFrom(inProt.getTransport().getClass())) {
                Socket socket = ((TSocket)inProt.getTransport()).getSocket();
                remoteAddress.set(socket.getInetAddress());
            }
            return this.wrapped.process(inProt, outProt);
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements ThriftHiveMetastore.Iface {
        public static final Log LOG = LOG;
        private static boolean createDefaultDB = false;
        private String rawStoreClassName;
        private final HiveConf hiveConf;
        private Warehouse wh;
        private final ThreadLocal<RawStore> threadLocalMS = new ThreadLocal<RawStore>(){

            @Override
            protected synchronized RawStore initialValue() {
                return null;
            }
        };
        private final ThreadLocal<Configuration> threadLocalConf = new ThreadLocal<Configuration>(){

            @Override
            protected synchronized Configuration initialValue() {
                return null;
            }
        };
        public static final String AUDIT_FORMAT = "ugi=%s\tip=%s\tcmd=%s\t";
        public static final Log auditLog = LogFactory.getLog((String)(HiveMetaStore.class.getName() + ".audit"));
        private static final ThreadLocal<Formatter> auditFormatter = new ThreadLocal<Formatter>(){

            @Override
            protected Formatter initialValue() {
                return new Formatter(new StringBuilder(HMSHandler.AUDIT_FORMAT.length() * 4));
            }
        };
        private boolean checkForDefaultDb;
        private static int nextSerialNum = 0;
        private static ThreadLocal<Integer> threadLocalId = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(nextSerialNum++);
            }
        };
        private int retryInterval = 0;
        private int retryLimit = 0;
        private JDOConnectionURLHook urlHook = null;
        private String urlHookClassName = "";
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;

        private final void logAuditEvent(String cmd) {
            UserGroupInformation ugi;
            if (!ShimLoader.getHadoopShims().isSecureShimImpl() || cmd == null) {
                return;
            }
            try {
                ugi = ShimLoader.getHadoopShims().getUGIForConf(this.getConf());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            InetAddress addr = TLoggingProcessor.getRemoteAddress();
            Formatter fmt = auditFormatter.get();
            ((StringBuilder)fmt.out()).setLength(0);
            auditLog.info((Object)fmt.format(AUDIT_FORMAT, ugi.getUserName(), addr == null ? "unknown-ip-addr" : addr.toString(), cmd).toString());
        }

        public static Integer get() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = new HiveConf(this.getClass());
            this.init();
        }

        public HMSHandler(String name, HiveConf conf) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = conf;
            this.init();
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        private boolean init() throws MetaException {
            this.rawStoreClassName = this.hiveConf.get("hive.metastore.rawstore.impl");
            this.checkForDefaultDb = this.hiveConf.getBoolean("hive.metastore.checkForDefaultDb", true);
            String alterHandlerName = this.hiveConf.get("hive.metastore.alter.impl", HiveAlterHandler.class.getName());
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(this.getClass(alterHandlerName, AlterHandler.class), (Configuration)this.hiveConf);
            this.wh = new Warehouse((Configuration)this.hiveConf);
            this.retryInterval = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREINTERVAL);
            this.retryLimit = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREATTEMPTS);
            this.updateConnectionURL((Configuration)this.hiveConf, null);
            this.createDefaultDB();
            if (this.hiveConf.getBoolean("hive.metastore.metrics.enabled", false)) {
                try {
                    Metrics.init();
                }
                catch (Exception e) {
                    LOG.error((Object)("error in Metrics init: " + e.getClass().getName() + " " + e.getMessage()));
                    MetaStoreUtils.printStackTrace(e);
                }
            }
            return true;
        }

        private String addPrefix(String s) {
            return threadLocalId.get() + ": " + s;
        }

        private <T> T executeWithRetry(Command<T> cmd) throws Exception {
            T ret = null;
            boolean gotNewConnectUrl = false;
            boolean reloadConf = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREFORCERELOADCONF);
            if (reloadConf) {
                this.updateConnectionURL(this.getConf(), null);
            }
            int retryCount = 0;
            Throwable caughtException = null;
            while (true) {
                try {
                    RawStore ms = this.getMS(reloadConf || gotNewConnectUrl);
                    ret = cmd.run(ms);
                    break;
                }
                catch (JDOFatalDataStoreException e) {
                    caughtException = e;
                }
                catch (JDODataStoreException e) {
                    caughtException = e;
                }
                if (retryCount >= this.retryLimit) {
                    throw caughtException;
                }
                assert (this.retryInterval >= 0);
                LOG.error((Object)String.format("JDO datastore error. Retrying metastore command after %d ms (attempt %d of %d)", this.retryInterval, ++retryCount, this.retryLimit));
                Thread.sleep(this.retryInterval);
                String lastUrl = HMSHandler.getConnectionURL(this.getConf());
                gotNewConnectUrl = this.updateConnectionURL(this.getConf(), lastUrl);
            }
            return ret;
        }

        private Configuration getConf() {
            Configuration conf = this.threadLocalConf.get();
            if (conf == null) {
                conf = new Configuration((Configuration)this.hiveConf);
                this.threadLocalConf.set(conf);
            }
            return conf;
        }

        private RawStore getMS(boolean reloadConf) throws MetaException {
            RawStore ms = this.threadLocalMS.get();
            if (ms == null) {
                LOG.info((Object)this.addPrefix("Opening raw store with implemenation class:" + this.rawStoreClassName));
                ms = (RawStore)ReflectionUtils.newInstance(this.getClass(this.rawStoreClassName, RawStore.class), (Configuration)this.getConf());
                this.threadLocalMS.set(ms);
                ms = this.threadLocalMS.get();
            }
            if (reloadConf) {
                ms.setConf(this.getConf());
            }
            return ms;
        }

        private boolean updateConnectionURL(Configuration conf, String badUrl) throws MetaException {
            String connectUrl = null;
            String currentUrl = HMSHandler.getConnectionURL(conf);
            try {
                this.initConnectionUrlHook();
                if (this.urlHook != null) {
                    if (badUrl != null) {
                        this.urlHook.notifyBadConnectionUrl(badUrl);
                    }
                    connectUrl = this.urlHook.getJdoConnectionUrl((Configuration)this.hiveConf);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while getting connection URL from the hook: " + e));
            }
            if (connectUrl != null && !connectUrl.equals(currentUrl)) {
                LOG.error((Object)this.addPrefix(String.format("Overriding %s with %s", HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl)));
                conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl);
                return true;
            }
            return false;
        }

        private static String getConnectionURL(Configuration conf) {
            return conf.get(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), "");
        }

        private synchronized void initConnectionUrlHook() throws ClassNotFoundException {
            boolean urlHookChanged;
            String className = this.hiveConf.get(HiveConf.ConfVars.METASTORECONNECTURLHOOK.toString(), "").trim();
            if (className.equals("")) {
                this.urlHookClassName = "";
                this.urlHook = null;
                return;
            }
            boolean bl = urlHookChanged = !this.urlHookClassName.equals(className);
            if (this.urlHook == null || urlHookChanged) {
                this.urlHookClassName = className.trim();
                Class<?> urlHookClass = Class.forName(this.urlHookClassName, true, JavaUtils.getClassLoader());
                this.urlHook = (JDOConnectionURLHook)ReflectionUtils.newInstance(urlHookClass, null);
            }
        }

        private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
            try {
                ms.getDatabase("default");
            }
            catch (NoSuchObjectException e) {
                ms.createDatabase(new Database("default", "Default Hive database", this.wh.getDefaultDatabasePath("default").toString(), null));
            }
            createDefaultDB = true;
        }

        private void createDefaultDB() throws MetaException {
            if (createDefaultDB || !this.checkForDefaultDb) {
                return;
            }
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.createDefaultDB_core(ms);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw new MetaException(e.getMessage());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        private Class<?> getClass(String rawStoreClassName, Class<?> class1) throws MetaException {
            try {
                return Class.forName(rawStoreClassName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MetaException(rawStoreClassName + " class not found");
            }
        }

        private void logInfo(String m) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + m));
            this.logAuditEvent(m);
        }

        public String startFunction(String function, String extraLogInfo) {
            this.incrementCounter(function);
            this.logInfo(function + extraLogInfo);
            try {
                Metrics.startScope((String)function);
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception when starting metrics scope" + e.getClass().getName() + " " + e.getMessage()));
                MetaStoreUtils.printStackTrace(e);
            }
            return function;
        }

        public String startFunction(String function) {
            return this.startFunction(function, "");
        }

        public String startTableFunction(String function, String db, String tbl) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl);
        }

        public String startPartitionFunction(String function, String db, String tbl, List<String> partVals) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "[" + StringUtils.join(partVals, (String)",") + "]");
        }

        public void endFunction(String function) {
            try {
                Metrics.endScope((String)function);
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception when closing metrics scope" + e));
            }
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public void shutdown() {
            this.logInfo("Shutting down the object store...");
            RawStore ms = this.threadLocalMS.get();
            if (ms != null) {
                ms.shutdown();
            }
            System.exit(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_database_core(RawStore ms, Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(db.getName())) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (null == db.getLocationUri()) {
                    db.setLocationUri(this.wh.getDefaultDatabasePath(db.getName()).toString());
                }
                ms.createDatabase(db);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else {
                    this.wh.mkdirs(new Path(db.getLocationUri()));
                }
            }
        }

        @Override
        public void create_database(final Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            this.startFunction("create_database", ": " + db.getName() + " " + db.getLocationUri() + " " + db.getDescription());
            try {
                try {
                    if (null != this.get_database(db.getName())) {
                        throw new AlreadyExistsException("Database " + db.getName() + " already exists");
                    }
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_database_core(ms, db);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("create_database");
            }
        }

        @Override
        public Database get_database(final String name) throws NoSuchObjectException, MetaException {
            this.startFunction("get_database", ": " + name);
            Database db = null;
            try {
                db = this.executeWithRetry(new Command<Database>(){

                    @Override
                    Database run(RawStore ms) throws Exception {
                        return ms.getDatabase(name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_database");
            }
            return db;
        }

        @Override
        public void alter_database(final String dbName, final Database db) throws NoSuchObjectException, TException, MetaException {
            this.startFunction("alter_database" + dbName);
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.alterDatabase(dbName, db);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_database");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_database_core(RawStore ms, String name, boolean deleteData) throws NoSuchObjectException, InvalidOperationException, MetaException {
            boolean success = false;
            Database db = null;
            try {
                ms.openTransaction();
                db = ms.getDatabase(name);
                if (!this.get_all_tables(db.getName()).isEmpty()) {
                    throw new InvalidOperationException("Database " + db.getName() + " is not empty");
                }
                if (ms.dropDatabase(name)) {
                    success = ms.commitTransaction();
                }
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData) {
                    this.wh.deleteDir(new Path(db.getLocationUri()), true);
                }
            }
        }

        @Override
        public void drop_database(final String dbName, final boolean deleteData) throws NoSuchObjectException, InvalidOperationException, MetaException {
            this.startFunction("drop_database", ": " + dbName);
            if ("default".equalsIgnoreCase(dbName)) {
                this.endFunction("drop_database");
                throw new MetaException("Can not drop default database");
            }
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.drop_database_core(ms, dbName, deleteData);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_database");
            }
        }

        @Override
        public List<String> get_databases(final String pattern) throws MetaException {
            this.startFunction("get_databases", ": " + pattern);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getDatabases(pattern);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_databases");
            }
            return ret;
        }

        @Override
        public List<String> get_all_databases() throws MetaException {
            this.startFunction("get_all_databases");
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getAllDatabases();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_all_databases");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(type.getName())) {
                throw new InvalidObjectException("Invalid type name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (this.is_type_exists(ms, type.getName())) {
                    throw new AlreadyExistsException("Type " + type.getName() + " already exists");
                }
                ms.createType(type);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean create_type(final Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_type", ": " + type.getName());
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_type_core(ms, type);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("create_type");
            }
            return ret;
        }

        @Override
        public Type get_type(final String name) throws MetaException, NoSuchObjectException {
            Type ret;
            this.startFunction("get_type", ": " + name);
            try {
                ret = this.executeWithRetry(new Command<Type>(){

                    @Override
                    Type run(RawStore ms) throws Exception {
                        Type type = ms.getType(name);
                        if (null == type) {
                            throw new NoSuchObjectException("Type \"" + name + "\" not found.");
                        }
                        return type;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_type");
            }
            return ret;
        }

        private boolean is_type_exists(RawStore ms, String typeName) throws MetaException {
            return ms.getType(typeName) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_type_core(RawStore ms, String typeName) throws NoSuchObjectException, MetaException {
            boolean success = false;
            try {
                ms.openTransaction();
                if (!this.is_type_exists(ms, typeName)) {
                    throw new NoSuchObjectException(typeName + " doesn't exist");
                }
                if (!ms.dropType(typeName)) {
                    throw new MetaException("Unable to drop type " + typeName);
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_type(final String name) throws MetaException {
            this.startFunction("drop_type", ": " + name);
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.dropType(name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_type");
            }
            return ret;
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.startFunction("get_type_all", ": " + name);
            this.endFunction("get_type_all");
            throw new MetaException("Not yet implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void create_table_core(RawStore ms, Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(tbl.getTableName()) || !MetaStoreUtils.validateColNames(tbl.getSd().getCols()) || tbl.getPartitionKeys() != null && !MetaStoreUtils.validateColNames(tbl.getPartitionKeys())) {
                throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
            }
            Path tblPath = null;
            boolean success = false;
            boolean madeDir = false;
            try {
                ms.openTransaction();
                if (this.is_table_exists(ms, tbl.getDbName(), tbl.getTableName())) {
                    throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists");
                }
                if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                    if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                        tblPath = this.wh.getDefaultTablePath(tbl.getDbName(), tbl.getTableName());
                    } else {
                        if (!this.isExternal(tbl) && !MetaStoreUtils.isNonNativeTable(tbl)) {
                            LOG.warn((Object)("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName()));
                        }
                        tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                    }
                    tbl.getSd().setLocation(tblPath.toString());
                }
                if (tblPath != null && !this.wh.isDir(tblPath)) {
                    if (!this.wh.mkdirs(tblPath)) {
                        throw new MetaException(tblPath + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                tbl.setCreateTime((int)time);
                if (tbl.getParameters() == null || tbl.getParameters().get("transient_lastDdlTime") == null) {
                    tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                }
                ms.createTable(tbl);
                success = ms.commitTransaction();
                if (success) return;
                ms.rollbackTransaction();
                if (!madeDir) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(tblPath, true);
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true);
        }

        @Override
        public void create_table(final Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_table", ": db=" + tbl.getDbName() + " tbl=" + tbl.getTableName());
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_table_core(ms, tbl);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("create_table");
            }
        }

        private boolean is_table_exists(RawStore ms, String dbname, String name) throws MetaException {
            return ms.getTable(dbname, name) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void drop_table_core(RawStore ms, String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
            boolean success = false;
            boolean isExternal = false;
            Path tblPath = null;
            Table tbl = null;
            isExternal = false;
            boolean isIndexTable = false;
            try {
                ms.openTransaction();
                tbl = this.get_table(dbname, name);
                if (tbl == null) {
                    throw new NoSuchObjectException(name + " doesn't exist");
                }
                if (tbl.getSd() == null) {
                    throw new MetaException("Table metadata is corrupted");
                }
                isIndexTable = this.isIndexTable(tbl);
                if (isIndexTable) {
                    throw new RuntimeException("The table " + name + " is an index table. Please do drop index instead.");
                }
                if (!isIndexTable) {
                    try {
                        List<Index> indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                        while (indexes != null && indexes.size() > 0) {
                            for (Index idx : indexes) {
                                this.drop_index_by_name(dbname, name, idx.getIndexName(), true);
                            }
                            indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                        }
                    }
                    catch (TException e) {
                        throw new MetaException(e.getMessage());
                    }
                }
                isExternal = this.isExternal(tbl);
                if (tbl.getSd().getLocation() != null) {
                    tblPath = new Path(tbl.getSd().getLocation());
                }
                if (!ms.dropTable(dbname, name)) {
                    throw new MetaException("Unable to drop table");
                }
                tbl = null;
                success = ms.commitTransaction();
                if (!success) {
                    ms.rollbackTransaction();
                    return;
                }
                if (!deleteData || tblPath == null || isExternal) return;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                    throw throwable;
                } else {
                    if (!deleteData || tblPath == null || isExternal) throw throwable;
                    this.wh.deleteDir(tblPath, true);
                }
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true);
        }

        @Override
        public void drop_table(final String dbname, final String name, final boolean deleteData) throws NoSuchObjectException, MetaException {
            this.startTableFunction("drop_table", dbname, name);
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.drop_table_core(ms, dbname, name, deleteData);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_table");
            }
        }

        private boolean isExternal(Table table) {
            return MetaStoreUtils.isExternalTable(table);
        }

        private boolean isIndexTable(Table table) {
            return MetaStoreUtils.isIndexTable(table);
        }

        @Override
        public Table get_table(final String dbname, final String name) throws MetaException, NoSuchObjectException {
            Table t = null;
            this.startTableFunction("get_table", dbname, name);
            try {
                t = this.executeWithRetry(new Command<Table>(){

                    @Override
                    Table run(RawStore ms) throws Exception {
                        Table t = ms.getTable(dbname, name);
                        if (t == null) {
                            throw new NoSuchObjectException(dbname + "." + name + " table not found");
                        }
                        return t;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_table");
            }
            return t;
        }

        public boolean set_table_parameters(String dbname, String name, Map<String, String> params) throws NoSuchObjectException, MetaException {
            this.endFunction(this.startTableFunction("set_table_parameters", dbname, name));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Partition append_partition_common(RawStore ms, String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            Partition part = new Partition();
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                ms.openTransaction();
                part = new Partition();
                part.setDbName(dbName);
                part.setTableName(tableName);
                part.setValues(part_vals);
                Table tbl = ms.getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                part.setSd(tbl.getSd());
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                part.getSd().setLocation(partLocation.toString());
                Partition old_part = null;
                try {
                    old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                }
                catch (NoSuchObjectException e) {
                    old_part = null;
                }
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                success = ms.addPartition(part);
                if (success) {
                    success = ms.commitTransaction();
                }
                if (success) return part;
                ms.rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        @Override
        public Partition append_partition(final String dbName, final String tableName, final List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startPartitionFunction("append_partition", dbName, tableName, part_vals);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug((Object)part);
                }
            }
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.append_partition_common(ms, dbName, tableName, part_vals);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("append_partition");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add_partitions_core(RawStore ms, List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            String db = parts.get(0).getDbName();
            String tbl = parts.get(0).getTableName();
            this.logInfo("add_partitions : db=" + db + " tbl=" + tbl);
            boolean success = false;
            try {
                ms.openTransaction();
                for (Partition part : parts) {
                    this.add_partition(part);
                }
                success = true;
                ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
            return parts.size();
        }

        public int add_partitions(final List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.startFunction("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            Integer ret = null;
            try {
                ret = this.executeWithRetry(new Command<Integer>(){

                    @Override
                    Integer run(RawStore ms) throws Exception {
                        int ret = HMSHandler.this.add_partitions_core(ms, parts);
                        return ret;
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("add_partition");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Partition add_partition_core(RawStore ms, Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                ms.openTransaction();
                Partition old_part = null;
                try {
                    old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                }
                catch (NoSuchObjectException e) {
                    old_part = null;
                }
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                Table tbl = ms.getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                String partLocationStr = part.getSd().getLocation();
                partLocation = partLocationStr == null || partLocationStr.isEmpty() ? new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues())) : this.wh.getDnsPath(new Path(partLocationStr));
                part.getSd().setLocation(partLocation.toString());
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                if (part.getParameters() == null || part.getParameters().get("transient_lastDdlTime") == null) {
                    part.putToParameters("transient_lastDdlTime", Long.toString(time));
                }
                boolean bl = success = ms.addPartition(part) && ms.commitTransaction();
                if (success) return part;
                ms.rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        @Override
        public Partition add_partition(final Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startTableFunction("add_partition", part.getDbName(), part.getTableName());
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.add_partition_core(ms, part);
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("add_partition");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_partition_common(RawStore ms, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws MetaException, NoSuchObjectException {
            block15: {
                Path partPath;
                block16: {
                    Path archiveParentDir;
                    block17: {
                        boolean success = false;
                        partPath = null;
                        Table tbl = null;
                        Partition part = null;
                        boolean isArchived = false;
                        archiveParentDir = null;
                        try {
                            ms.openTransaction();
                            part = ms.getPartition(db_name, tbl_name, part_vals);
                            if (part == null) {
                                throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                            }
                            isArchived = MetaStoreUtils.isArchived(part);
                            if (isArchived) {
                                archiveParentDir = MetaStoreUtils.getOriginalLocation(part);
                            }
                            if (part.getSd() == null || part.getSd().getLocation() == null) {
                                throw new MetaException("Partition metadata is corrupted");
                            }
                            if (!ms.dropPartition(db_name, tbl_name, part_vals)) {
                                throw new MetaException("Unable to drop partition");
                            }
                            success = ms.commitTransaction();
                            partPath = new Path(part.getSd().getLocation());
                            tbl = this.get_table(db_name, tbl_name);
                            if (!success) {
                                ms.rollbackTransaction();
                                break block15;
                            }
                            if (!deleteData || partPath == null && archiveParentDir == null || tbl == null || this.isExternal(tbl)) break block15;
                            if (!isArchived) break block16;
                            if ($assertionsDisabled || archiveParentDir != null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (!success) {
                                ms.rollbackTransaction();
                            } else if (deleteData && (partPath != null || archiveParentDir != null) && tbl != null && !this.isExternal(tbl)) {
                                if (isArchived) {
                                    assert (archiveParentDir != null);
                                    this.wh.deleteDir(archiveParentDir, true);
                                } else {
                                    assert (partPath != null);
                                    this.wh.deleteDir(partPath, true);
                                }
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    this.wh.deleteDir(archiveParentDir, true);
                    break block15;
                }
                assert (partPath != null);
                this.wh.deleteDir(partPath, true);
            }
            return true;
        }

        @Override
        public boolean drop_partition(final String db_name, final String tbl_name, final List<String> part_vals, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startPartitionFunction("drop_partition", db_name, tbl_name, part_vals);
            LOG.info((Object)("Partition values:" + part_vals));
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_partition_common(ms, db_name, tbl_name, part_vals, deleteData);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_partition");
            }
            return ret;
        }

        @Override
        public Partition get_partition(final String db_name, final String tbl_name, final List<String> part_vals) throws MetaException, NoSuchObjectException {
            this.startPartitionFunction("get_partition", db_name, tbl_name, part_vals);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return ms.getPartition(db_name, tbl_name, part_vals);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partition");
            }
            return ret;
        }

        @Override
        public Partition get_partition_with_auth(final String db_name, final String tbl_name, final List<String> part_vals, final String user_name, final List<String> group_names) throws MetaException, NoSuchObjectException, TException {
            this.startPartitionFunction("get_partition_with_auth", db_name, tbl_name, part_vals);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return ms.getPartitionWithAuth(db_name, tbl_name, part_vals, user_name, group_names);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partition_with_auth");
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions(final String db_name, final String tbl_name, final short max_parts) throws NoSuchObjectException, MetaException {
            this.startTableFunction("get_partitions", db_name, tbl_name);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitions(db_name, tbl_name, max_parts);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partitions");
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions_with_auth(final String dbName, final String tblName, final short maxParts, final String userName, final List<String> groupNames) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_partitions_with_auth", dbName, tblName);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partitions_with_auth");
            }
            return ret;
        }

        @Override
        public List<String> get_partition_names(final String db_name, final String tbl_name, final short max_parts) throws MetaException {
            this.startTableFunction("get_partition_names", db_name, tbl_name);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.listPartitionNames(db_name, tbl_name, max_parts);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partition_names");
            }
            return ret;
        }

        private void alter_partition_core(RawStore ms, String db_name, String tbl_name, Partition new_part) throws InvalidOperationException, MetaException, TException {
            try {
                if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(new_part.getParameters().get("transient_lastDdlTime")) == 0) {
                    new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                ms.alterPartition(db_name, tbl_name, new_part);
            }
            catch (InvalidObjectException e) {
                throw new InvalidOperationException("alter is not possible");
            }
        }

        @Override
        public void alter_partition(final String db_name, final String tbl_name, final Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.startTableFunction("alter_partition", db_name, tbl_name);
            LOG.info((Object)("Partition values:" + new_part.getValues()));
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.alter_partition_core(ms, db_name, tbl_name, new_part);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_partition");
            }
        }

        public boolean create_index(Index index_def) throws IndexAlreadyExistsException, MetaException {
            this.endFunction(this.startFunction("create_index"));
            throw new MetaException("Not yet implemented");
        }

        @Override
        public void alter_index(final String dbname, final String base_table_name, final String index_name, final Index newIndex) throws InvalidOperationException, MetaException {
            this.startFunction("alter_index", ": db=" + dbname + " base_tbl=" + base_table_name + " idx=" + index_name + " newidx=" + newIndex.getIndexName());
            newIndex.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        ms.alterIndex(dbname, base_table_name, index_name, newIndex);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_index");
            }
        }

        public String getVersion() throws TException {
            this.endFunction(this.startFunction("getVersion"));
            return "3.0";
        }

        @Override
        public void alter_table(final String dbname, final String name, final Table newTable) throws InvalidOperationException, MetaException {
            this.startFunction("alter_table", ": db=" + dbname + " tbl=" + name + " newtbl=" + newTable.getTableName());
            if (newTable.getParameters() == null || newTable.getParameters().get("transient_lastDdlTime") == null) {
                newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.alterHandler.alterTable(ms, HMSHandler.this.wh, dbname, name, newTable);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("alter_table");
            }
        }

        @Override
        public List<String> get_tables(final String dbname, final String pattern) throws MetaException {
            List<String> ret;
            this.startFunction("get_tables", ": db=" + dbname + " pat=" + pattern);
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getTables(dbname, pattern);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_tables");
            }
            return ret;
        }

        @Override
        public List<String> get_all_tables(final String dbname) throws MetaException {
            List<String> ret;
            this.startFunction("get_all_tables", ": db=" + dbname);
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getAllTables(dbname);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_all_tables");
            }
            return ret;
        }

        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_fields", ": db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            try {
                Table tbl;
                try {
                    tbl = this.get_table(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                boolean getColsFromSerDe = SerDeUtils.shouldGetColsFromSerDe((String)tbl.getSd().getSerdeInfo().getSerializationLib());
                if (!getColsFromSerDe) {
                    List<FieldSchema> list = tbl.getSd().getCols();
                    return list;
                }
                Deserializer s = MetaStoreUtils.getDeserializer((Configuration)this.hiveConf, tbl);
                List<FieldSchema> list = MetaStoreUtils.getFieldsFromDeserializer(tableName, s);
                return list;
            }
            finally {
                this.endFunction("get_fields");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_schema", ": db=" + db + "tbl=" + tableName);
            try {
                Table tbl;
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                try {
                    tbl = this.get_table(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                List<FieldSchema> fieldSchemas = this.get_fields(db, base_table_name);
                if (tbl == null || fieldSchemas == null) {
                    throw new UnknownTableException(tableName + " doesn't exist");
                }
                if (tbl.getPartitionKeys() != null) {
                    fieldSchemas.addAll(tbl.getPartitionKeys());
                }
                List<FieldSchema> list = fieldSchemas;
                return list;
            }
            finally {
                this.endFunction("get_schema");
            }
        }

        public String getCpuProfile(int profileDurationInSec) throws TException {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get_config_value(String name, String defaultValue) throws TException, ConfigValSecurityException {
            this.startFunction("get_config_value", ": name=" + name + " defaultValue=" + defaultValue);
            try {
                if (name == null) {
                    String string = defaultValue;
                    return string;
                }
                if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
                    throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
                }
                String toReturn = defaultValue;
                try {
                    toReturn = this.hiveConf.get(name, defaultValue);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)(threadLocalId.get().toString() + ": " + "RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause()));
                }
                String string = toReturn;
                return string;
            }
            finally {
                this.endFunction("get_config_value");
            }
        }

        private List<String> getPartValsFromName(RawStore ms, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
            LinkedHashMap<String, String> hm = Warehouse.makeSpecFromName(partName);
            Table t = ms.getTable(dbName, tblName);
            if (t == null) {
                throw new InvalidObjectException(dbName + "." + tblName + " table not found");
            }
            ArrayList<String> partVals = new ArrayList<String>();
            for (FieldSchema field : t.getPartitionKeys()) {
                String key = field.getName();
                String val = hm.get(key);
                if (val == null) {
                    throw new InvalidObjectException("incomplete partition name - missing " + key);
                }
                partVals.add(val);
            }
            return partVals;
        }

        private Partition get_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            Partition p = ms.getPartition(db_name, tbl_name, partVals);
            if (p == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " partition (" + part_name + ") not found");
            }
            return p;
        }

        @Override
        public Partition get_partition_by_name(final String db_name, final String tbl_name, final String part_name) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.get_partition_by_name_core(ms, db_name, tbl_name, part_name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partition_by_name");
            }
            return ret;
        }

        @Override
        public Partition append_partition_by_name(final String db_name, final String tbl_name, final String part_name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("append_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        List partVals = HMSHandler.this.getPartValsFromName(ms, db_name, tbl_name, part_name);
                        return HMSHandler.this.append_partition_common(ms, db_name, tbl_name, partVals);
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("append_partition_by_name");
            }
            return ret;
        }

        private boolean drop_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            return this.drop_partition_common(ms, db_name, tbl_name, partVals, deleteData);
        }

        @Override
        public boolean drop_partition_by_name(final String db_name, final String tbl_name, final String part_name, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_partition_by_name_core(ms, db_name, tbl_name, part_name, deleteData);
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_partition_by_name");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
            this.startPartitionFunction("get_partitions_ps", db_name, tbl_name, part_vals);
            try {
                List<Partition> list = this.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, null, null);
                return list;
            }
            finally {
                this.endFunction("get_partitions_ps");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_ps_with_auth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, TException {
            this.startPartitionFunction("get_partitions_ps_with_auth", db_name, tbl_name, part_vals);
            List<Partition> parts = null;
            ArrayList<Partition> matchingParts = new ArrayList<Partition>();
            try {
                try {
                    parts = this.get_partitions(db_name, tbl_name, (short)-1);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
                for (Partition p : parts) {
                    if (!MetaStoreUtils.pvalMatches(part_vals, p.getValues())) continue;
                    matchingParts.add(p);
                }
                ArrayList<Partition> arrayList = matchingParts;
                return arrayList;
            }
            finally {
                this.endFunction("get_partitions_ps_with_auth");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> get_partition_names_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
            this.startPartitionFunction("get_partitions_names_ps", db_name, tbl_name, part_vals);
            try {
                try {
                    Table t = this.get_table(db_name, tbl_name);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
                List<String> partNames = this.get_partition_names(db_name, tbl_name, max_parts);
                ArrayList<String> filteredPartNames = new ArrayList<String>();
                for (String name : partNames) {
                    LinkedHashMap<String, String> spec = Warehouse.makeSpecFromName(name);
                    ArrayList<String> vals = new ArrayList<String>();
                    for (String val : spec.values()) {
                        vals.add(val);
                    }
                    if (!MetaStoreUtils.pvalMatches(part_vals, vals)) continue;
                    filteredPartNames.add(name);
                }
                ArrayList<String> arrayList = filteredPartNames;
                return arrayList;
            }
            finally {
                this.endFunction("get_partitions_names_ps");
            }
        }

        @Override
        public List<String> partition_name_to_vals(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new ArrayList<String>();
            }
            LinkedHashMap<String, String> map = Warehouse.makeSpecFromName(part_name);
            ArrayList<String> part_vals = new ArrayList<String>();
            part_vals.addAll(map.values());
            return part_vals;
        }

        @Override
        public Map<String, String> partition_name_to_spec(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new HashMap<String, String>();
            }
            return Warehouse.makeSpecFromName(part_name);
        }

        @Override
        public Index add_index(final Index newIndex, final Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("add_index", ": db=" + newIndex.getDbName() + " tbl=" + newIndex.getOrigTableName() + " index=" + newIndex.getIndexName());
            Index ret = null;
            try {
                ret = this.executeWithRetry(new Command<Index>(){

                    @Override
                    Index run(RawStore ms) throws Exception {
                        return HMSHandler.this.add_index_core(ms, newIndex, indexTable);
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("add_index");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Index add_index_core(RawStore ms, Index index, Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            boolean indexTableCreated = false;
            try {
                ms.openTransaction();
                Index old_index = null;
                try {
                    old_index = this.get_index_by_name(index.getDbName(), index.getOrigTableName(), index.getIndexName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (old_index != null) {
                    throw new AlreadyExistsException("Index already exists:" + index);
                }
                Table origTbl = ms.getTable(index.getDbName(), index.getOrigTableName());
                if (origTbl == null) {
                    throw new InvalidObjectException("Unable to add index because database or the orginal table do not exist");
                }
                long time = System.currentTimeMillis() / 1000L;
                Table indexTbl = indexTable;
                if (indexTbl != null) {
                    try {
                        indexTbl = ms.getTable(index.getDbName(), index.getIndexTableName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (indexTbl != null) {
                        throw new InvalidObjectException("Unable to add index because index table already exists");
                    }
                    this.create_table(indexTable);
                    indexTableCreated = true;
                }
                index.setCreateTime((int)time);
                index.putToParameters("transient_lastDdlTime", Long.toString(time));
                ms.addIndex(index);
                success = ms.commitTransaction();
                Index index2 = index;
                return index2;
            }
            finally {
                if (!success) {
                    if (indexTableCreated) {
                        try {
                            this.drop_table(index.getDbName(), index.getIndexTableName(), false);
                        }
                        catch (Exception e) {}
                    }
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_index_by_name(final String dbName, final String tblName, final String indexName, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_index_by_name_core(ms, dbName, tblName, indexName, deleteData);
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_index_by_name");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_index_by_name_core(RawStore ms, String dbName, String tblName, String indexName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            boolean success = false;
            Path tblPath = null;
            try {
                ms.openTransaction();
                Index index = this.get_index_by_name(dbName, tblName, indexName);
                if (index == null) {
                    throw new NoSuchObjectException(indexName + " doesn't exist");
                }
                ms.dropIndex(dbName, tblName, indexName);
                String idxTblName = index.getIndexTableName();
                if (idxTblName != null) {
                    Table tbl = null;
                    tbl = this.get_table(dbName, idxTblName);
                    if (tbl.getSd() == null) {
                        throw new MetaException("Table metadata is corrupted");
                    }
                    if (tbl.getSd().getLocation() != null) {
                        tblPath = new Path(tbl.getSd().getLocation());
                    }
                    if (!ms.dropTable(dbName, idxTblName)) {
                        throw new MetaException("Unable to drop underlying data table " + idxTblName + " for index " + idxTblName);
                    }
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    return false;
                }
                if (deleteData && tblPath != null) {
                    this.wh.deleteDir(tblPath, true);
                }
            }
            return true;
        }

        @Override
        public Index get_index_by_name(final String dbName, final String tblName, final String indexName) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            Index ret = null;
            try {
                ret = this.executeWithRetry(new Command<Index>(){

                    @Override
                    Index run(RawStore ms) throws Exception {
                        return HMSHandler.this.get_index_by_name_core(ms, dbName, tblName, indexName);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("drop_index_by_name");
            }
            return ret;
        }

        private Index get_index_by_name_core(RawStore ms, String db_name, String tbl_name, String index_name) throws MetaException, NoSuchObjectException, TException {
            Index index = ms.getIndex(db_name, tbl_name, index_name);
            if (index == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " index=" + index_name + " not found");
            }
            return index;
        }

        @Override
        public List<String> get_index_names(final String dbName, final String tblName, final short maxIndexes) throws MetaException, TException {
            this.startTableFunction("get_index_names", dbName, tblName);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.listIndexNames(dbName, tblName, maxIndexes);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_index_names");
            }
            return ret;
        }

        @Override
        public List<Index> get_indexes(final String dbName, final String tblName, final short maxIndexes) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_indexes", dbName, tblName);
            List<Index> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Index>>(){

                    @Override
                    List<Index> run(RawStore ms) throws Exception {
                        return ms.getIndexes(dbName, tblName, maxIndexes);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_indexes");
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions_by_filter(final String dbName, final String tblName, final String filter, final short maxParts) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_filter", dbName, tblName);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitionsByFilter(dbName, tblName, filter, maxParts);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            finally {
                this.endFunction("get_partitions_by_filter");
            }
            return ret;
        }

        @Override
        public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                String partName = this.getPartName(hiveObject);
                return this.get_column_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                String partName = this.getPartName(hiveObject);
                return this.get_partition_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.get_db_privilege_set(hiveObject.getDbName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.get_table_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), userName, groupNames);
            }
            return null;
        }

        private String getPartName(HiveObjectRef hiveObject) throws MetaException {
            String partName = null;
            List<String> partValue = hiveObject.getPartValues();
            if (partValue != null && partValue.size() > 0) {
                try {
                    Table table = this.get_table(hiveObject.getDbName(), hiveObject.getObjectName());
                    partName = Warehouse.makePartName(table.getPartitionKeys(), partValue);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
            }
            return partName;
        }

        public PrincipalPrivilegeSet get_column_privilege_set(final String dbName, final String tableName, final String partName, final String columnName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_column_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getColumnPrivilegeSet(dbName, tableName, partName, columnName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_db_privilege_set(final String dbName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_db_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getDBPrivilegeSet(dbName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_partition_privilege_set(final String dbName, final String tableName, final String partName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_partition_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getPartitionPrivilegeSet(dbName, tableName, partName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_table_privilege_set(final String dbName, final String tableName, final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_table_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getTablePrivilegeSet(dbName, tableName, userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean grant_role(final String roleName, final String userName, final PrincipalType principalType, final String grantor, final PrincipalType grantorType, final boolean grantOption) throws MetaException, TException {
            this.incrementCounter("add_role_member");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        Role role = ms.getRole(roleName);
                        return ms.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<Role> list_roles(final String principalName, final PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_roles");
            List<Role> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Role>>(){

                    @Override
                    List<Role> run(RawStore ms) throws Exception {
                        ArrayList<Role> result = new ArrayList<Role>();
                        List<MRoleMap> roleMap = ms.listRoles(principalName, principalType);
                        if (roleMap != null) {
                            for (MRoleMap role : roleMap) {
                                MRole r = role.getRole();
                                result.add(new Role(r.getRoleName(), r.getCreateTime(), r.getOwnerName()));
                            }
                        }
                        return result;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean create_role(final Role role) throws MetaException, TException {
            this.incrementCounter("create_role");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.addRole(role.getRoleName(), role.getOwnerName());
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean drop_role(final String roleName) throws MetaException, TException {
            this.incrementCounter("drop_role");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.removeRole(roleName);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<String> get_role_names() throws MetaException, TException {
            this.incrementCounter("get_role_names");
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.listRoleNames();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public boolean grant_privileges(final PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("grant_privileges");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.grantPrivileges(privileges);
                    }
                });
            }
            catch (MetaException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_role(final String roleName, final String userName, final PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("remove_role_member");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        Role mRole = ms.getRole(roleName);
                        return ms.revokeRole(mRole, userName, principalType);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_privileges(final PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("revoke_privileges");
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.revokePrivileges(privileges);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_user_privilege_set(final String userName, final List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_user_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.executeWithRetry(new Command<PrincipalPrivilegeSet>(){

                    @Override
                    PrincipalPrivilegeSet run(RawStore ms) throws Exception {
                        return ms.getUserPrivilegeSet(userName, groupNames);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalType getPrincipalType(String principalType) {
            return PrincipalType.valueOf(principalType);
        }

        @Override
        public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.list_global_privileges(principalName, principalType);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.list_db_privileges(principalName, principalType, hiveObject.getDbName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.list_table_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                return this.list_partition_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
            }
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                return this.list_column_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues(), hiveObject.getColumnName());
            }
            return null;
        }

        public List<HiveObjectPrivilege> list_column_privileges(final String principalName, final PrincipalType principalType, final String dbName, final String tableName, final List<String> partValues, final String columnName) throws MetaException, TException {
            this.incrementCounter("list_security_column_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        ArrayList<HiveObjectPrivilege> result;
                        block5: {
                            block4: {
                                String partName = null;
                                if (partValues != null && partValues.size() > 0) {
                                    Table tbl = HMSHandler.this.get_table(dbName, tableName);
                                    partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                                }
                                result = null;
                                if (partName == null) break block4;
                                Partition part = null;
                                part = HMSHandler.this.get_partition_by_name(dbName, tableName, partName);
                                List<MPartitionColumnPrivilege> mPartitionCols = ms.listPrincipalPartitionColumnGrants(principalName, principalType, dbName, tableName, partName, columnName);
                                if (mPartitionCols.size() <= 0) break block5;
                                result = new ArrayList();
                                for (int i = 0; i < mPartitionCols.size(); ++i) {
                                    MPartitionColumnPrivilege sCol = mPartitionCols.get(i);
                                    HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, part == null ? null : part.getValues(), sCol.getColumnName());
                                    HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
                                    result.add(secObj);
                                }
                                break block5;
                            }
                            List<MTableColumnPrivilege> mTableCols = ms.listPrincipalTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
                            if (mTableCols.size() > 0) {
                                result = new ArrayList<HiveObjectPrivilege>();
                                for (int i = 0; i < mTableCols.size(); ++i) {
                                    MTableColumnPrivilege sCol = mTableCols.get(i);
                                    HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, null, sCol.getColumnName());
                                    HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
                                    result.add(secObj);
                                }
                            }
                        }
                        return result;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_db_privileges(final String principalName, final PrincipalType principalType, final String dbName) throws MetaException, TException {
            this.incrementCounter("list_security_db_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<MDBPrivilege> mDbs = ms.listPrincipalDBGrants(principalName, principalType, dbName);
                        if (mDbs.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mDbs.size(); ++i) {
                                MDBPrivilege sDB = mDbs.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
                                HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sDB.getPrincipalName(), principalType, new PrivilegeGrantInfo(sDB.getPrivilege(), sDB.getCreateTime(), sDB.getGrantor(), PrincipalType.valueOf(sDB.getGrantorType()), sDB.getGrantOption()));
                                result.add(secObj);
                            }
                            return result;
                        }
                        return null;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_partition_privileges(final String principalName, final PrincipalType principalType, final String dbName, final String tableName, final List<String> partValues) throws MetaException, TException {
            this.incrementCounter("list_security_partition_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        Table tbl = HMSHandler.this.get_table(dbName, tableName);
                        String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                        List<MPartitionPrivilege> mParts = ms.listPrincipalPartitionGrants(principalName, principalType, dbName, tableName, partName);
                        if (mParts.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mParts.size(); ++i) {
                                MPartitionPrivilege sPart = mParts.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null);
                                HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sPart.getPrincipalName(), principalType, new PrivilegeGrantInfo(sPart.getPrivilege(), sPart.getCreateTime(), sPart.getGrantor(), PrincipalType.valueOf(sPart.getGrantorType()), sPart.getGrantOption()));
                                result.add(secObj);
                            }
                            return result;
                        }
                        return null;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_table_privileges(final String principalName, final PrincipalType principalType, final String dbName, final String tableName) throws MetaException, TException {
            this.incrementCounter("list_security_table_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<MTablePrivilege> mTbls = ms.listAllTableGrants(principalName, principalType, dbName, tableName);
                        if (mTbls.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mTbls.size(); ++i) {
                                MTablePrivilege sTbl = mTbls.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null);
                                HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sTbl.getPrincipalName(), principalType, new PrivilegeGrantInfo(sTbl.getPrivilege(), sTbl.getCreateTime(), sTbl.getGrantor(), PrincipalType.valueOf(sTbl.getGrantorType()), sTbl.getGrantOption()));
                                result.add(secObj);
                            }
                            return result;
                        }
                        return null;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_global_privileges(final String principalName, final PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_security_user_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<HiveObjectPrivilege>>(){

                    @Override
                    List<HiveObjectPrivilege> run(RawStore ms) throws Exception {
                        List<MGlobalPrivilege> mUsers = ms.listPrincipalGlobalGrants(principalName, principalType);
                        if (mUsers.size() > 0) {
                            ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                            for (int i = 0; i < mUsers.size(); ++i) {
                                MGlobalPrivilege sUsr = mUsers.get(i);
                                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
                                HiveObjectPrivilege secUser = new HiveObjectPrivilege(objectRef, sUsr.getPrincipalName(), principalType, new PrivilegeGrantInfo(sUsr.getPrivilege(), sUsr.getCreateTime(), sUsr.getGrantor(), PrincipalType.valueOf(sUsr.getGrantorType()), sUsr.getGrantOption()));
                                result.add(secUser);
                            }
                            return result;
                        }
                        return null;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public void cancel_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("cancel_delegation_token");
            try {
                HiveMetaStore.cancelDelegationToken(token_str_form);
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
            finally {
                this.endFunction("cancel_delegation_token");
            }
        }

        @Override
        public String get_delegation_token_with_signature(String renewer_kerberos_principal_name, String token_signature) throws MetaException, TException {
            this.startFunction("get_delegation_token_with_signature");
            try {
                String string = HiveMetaStore.getDelegationToken(renewer_kerberos_principal_name, token_signature);
                return string;
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
            finally {
                this.endFunction("get_delegation_token_with_signature");
            }
        }

        @Override
        public long renew_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("renew_delegation_token");
            try {
                long l = HiveMetaStore.renewDelegationToken(token_str_form);
                return l;
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
            finally {
                this.endFunction("renew_delegation_token");
            }
        }

        @Override
        public String get_delegation_token(String renewer_kerberos_principal_name) throws MetaException, TException {
            this.startFunction("get_delegation_token_with_signature");
            try {
                String string = HiveMetaStore.getDelegationToken(renewer_kerberos_principal_name);
                return string;
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
            finally {
                this.endFunction("get_delegation_token_with_signature");
            }
        }

        private static class Command<T> {
            private Command() {
            }

            T run(RawStore ms) throws Exception {
                return null;
            }
        }
    }
}

