/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model.elements;

import java.util.Arrays;
import java.util.List;
import ofc4j.model.elements.Element;
import ofc4j.model.metadata.Alias;
import ofc4j.model.metadata.Converter;
import ofc4j.util.BarConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChart
extends Element {
    private String colour;

    public BarChart() {
        this(Style.NORMAL);
    }

    public BarChart(Style style) {
        super(style.getStyle());
    }

    protected BarChart(String style) {
        super(style);
    }

    public BarChart addValues(Number ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    public BarChart addValues(List<Number> values) {
        this.getValues().addAll(values);
        return this;
    }

    public BarChart addBars(Bar ... bars) {
        this.getValues().addAll(Arrays.asList(bars));
        return this;
    }

    public BarChart addBars(List<Bar> bars) {
        this.getValues().addAll(bars);
        return this;
    }

    public String getColour() {
        return this.colour;
    }

    public BarChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    @Converter(value=BarConverter.class)
    public static class Bar {
        private Number top;
        private Number bottom;
        private String colour;
        @Alias(value="on-click")
        private String onClick;
        @Alias(value="tip")
        private String tooltip;

        public Bar(Number top, Number bottom, String colour) {
            this.setTop(top);
            this.setBottom(bottom);
            this.setColour(colour);
        }

        public Bar(Number top, Number bottom) {
            this(top, bottom, null);
        }

        public Bar(Number top, String colour) {
            this(top, null, colour);
        }

        public Bar(Number top) {
            this(top, null, null);
        }

        public Number getTop() {
            return this.top;
        }

        public Bar setTop(Number top) {
            this.top = top;
            return this;
        }

        public Number getBottom() {
            return this.bottom;
        }

        public Bar setBottom(Number bottom) {
            this.bottom = bottom;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public Bar setColour(String colour) {
            this.colour = colour;
            return this;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Bar setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public String getOnClick() {
            return this.onClick;
        }

        public void setOnClick(String onClick) {
            this.onClick = onClick;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        NORMAL("bar"),
        THREED("bar_3d"),
        GLASS("bar_glass");

        private String style;

        private Style(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

