/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ofc4j.model.elements.Element;
import ofc4j.model.metadata.Alias;
import ofc4j.model.metadata.Converter;
import ofc4j.util.StackKeyConverter;
import ofc4j.util.StackValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackedBarChart
extends Element {
    private List<StackKey> keys = new ArrayList<StackKey>();

    public StackedBarChart() {
        super("bar_stack");
    }

    public StackedBarChart addStack(Stack ... stacks) {
        return this.copy(Arrays.asList(stacks));
    }

    public StackedBarChart addStack(List<Stack> stacks) {
        return this.copy(stacks);
    }

    public StackedBarChart addKeys(StackKey ... keys) {
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    public Stack newStack() {
        Stack s = new Stack();
        this.copy(Arrays.asList(s));
        return s;
    }

    public Stack lastStack() {
        if (this.getValues().isEmpty()) {
            return this.newStack();
        }
        return this.stack(this.getStackCount() - 1);
    }

    public Stack stack(int index) {
        return new Stack((List)this.getValues().get(index));
    }

    public int getStackCount() {
        return this.getValues().size();
    }

    private StackedBarChart copy(List<Stack> stacks) {
        for (Stack s : stacks) {
            this.getValues().add(s.getBackingList());
        }
        return this;
    }

    @Converter(value=StackKeyConverter.class)
    public static class StackKey {
        private String text;
        private String colour;
        @Alias(value="font-size")
        private String fontSize;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getColour() {
            return this.colour;
        }

        public void setColour(String colour) {
            this.colour = colour;
        }

        public String getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }
    }

    @Converter(value=StackValueConverter.class)
    public static class StackValue {
        private Number val;
        private String colour;
        @Alias(value="on-click")
        private String onClick;

        public StackValue(Number value) {
            this(value, null);
        }

        public StackValue(Number value, String colour) {
            this.setValue(value);
            this.setColour(colour);
        }

        public Number getValue() {
            return this.val;
        }

        public StackValue setValue(Number val) {
            this.val = val;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public StackValue setColour(String colour) {
            this.colour = colour;
            return this;
        }

        public String getOnClick() {
            return this.onClick;
        }

        public void setOnClick(String onClick) {
            this.onClick = onClick;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stack {
        private transient List<Object> values;

        public Stack() {
            this.values = new ArrayList<Object>();
        }

        Stack(List<Object> values) {
            this.values = values;
        }

        public Stack addStackValues(StackValue ... values) {
            return this.doAdd(Arrays.asList(values));
        }

        public Stack addStackValues(List<StackValue> values) {
            return this.doAdd(values);
        }

        public Stack addValues(Number ... numbers) {
            return this.doAdd(Arrays.asList(numbers));
        }

        public Stack addValues(List<Number> numbers) {
            return this.doAdd(numbers);
        }

        private Stack doAdd(List<? extends Object> values) {
            this.values.addAll(values);
            return this;
        }

        List<Object> getBackingList() {
            return this.values;
        }
    }
}

