/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.oozie;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagEngine;
import org.apache.oozie.LocalOozieClient;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class SubWorkflowActionExecutor
extends ActionExecutor {
    public static final String ACTION_TYPE = "sub-workflow";
    public static final String LOCAL = "local";
    public static final String PARENT_ID = "oozie.wf.parent.id";
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    private static Set<String> FINAL_STATUS;

    protected SubWorkflowActionExecutor() {
        super(ACTION_TYPE);
    }

    @Override
    public void initActionType() {
        super.initActionType();
    }

    protected OozieClient getWorkflowClient(ActionExecutor.Context context, String oozieUri) {
        OozieClient oozieClient;
        if (oozieUri.equals(LOCAL)) {
            WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
            String user = workflow.getUser();
            String group = workflow.getGroup();
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user);
            oozieClient = new LocalOozieClient(dagEngine);
        } else {
            oozieClient = new OozieClient(oozieUri);
        }
        return oozieClient;
    }

    protected void injectInline(Element eConf, Configuration subWorkflowConf) throws IOException, ActionExecutorException {
        if (eConf != null) {
            String strConf = XmlUtils.prettyPrint(eConf).toString();
            XConfiguration conf = new XConfiguration(new StringReader(strConf));
            try {
                PropertiesUtils.checkDisallowedProperties(conf, DISALLOWED_DEFAULT_PROPERTIES);
            }
            catch (CommandException ex) {
                throw this.convertException(ex);
            }
            XConfiguration.copy(conf, subWorkflowConf);
        }
    }

    protected void injectCallback(ActionExecutor.Context context, Configuration conf) {
        String callback = context.getCallbackUrl("$status");
        if (conf.get("oozie.wf.workflow.notification.url") != null) {
            XLog.getLog(this.getClass()).warn("Sub-Workflow configuration has a custom job end notification URI, overriding");
        }
        conf.set("oozie.wf.workflow.notification.url", callback);
    }

    protected void injectRecovery(String externalId, Configuration conf) {
        conf.set("oozie.wf.external.id", externalId);
    }

    protected void injectParent(String parentId, Configuration conf) {
        conf.set(PARENT_ID, parentId);
    }

    protected String checkIfRunning(OozieClient oozieClient, String extId) throws OozieClientException {
        String jobId = oozieClient.getJobId(extId);
        if (jobId.equals("")) {
            return null;
        }
        return jobId;
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            Element eConf = XmlUtils.parseXml(action.getConf());
            Namespace ns = eConf.getNamespace();
            Element e = eConf.getChild("oozie", ns);
            String oozieUri = e == null ? LOCAL : e.getTextTrim();
            OozieClient oozieClient = this.getWorkflowClient(context, oozieUri);
            String subWorkflowId = null;
            String extId = context.getRecoveryId();
            String runningJobId = null;
            if (extId != null) {
                runningJobId = this.checkIfRunning(oozieClient, extId);
            }
            if (runningJobId == null) {
                String appPath = eConf.getChild("app-path", ns).getTextTrim();
                XConfiguration subWorkflowConf = new XConfiguration();
                XConfiguration parentConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
                if (eConf.getChild("propagate-configuration", ns) != null) {
                    XConfiguration.copy(parentConf, subWorkflowConf);
                }
                Configuration protoActionConf = context.getProtoActionConf();
                XConfiguration.copy(protoActionConf, subWorkflowConf);
                subWorkflowConf.set("oozie.wf.application.path", appPath);
                String group = ConfigUtils.getWithDeprecatedCheck((Configuration)parentConf, "oozie.job.acl", "group.name", null);
                if (group != null) {
                    subWorkflowConf.set("group.name", group);
                }
                this.injectInline(eConf.getChild("configuration", ns), subWorkflowConf);
                this.injectCallback(context, subWorkflowConf);
                this.injectRecovery(extId, subWorkflowConf);
                this.injectParent(context.getWorkflow().getId(), subWorkflowConf);
                JobUtils.normalizeAppPath(context.getWorkflow().getUser(), context.getWorkflow().getGroup(), subWorkflowConf);
                subWorkflowId = oozieClient.run(subWorkflowConf.toProperties());
            } else {
                subWorkflowId = runningJobId;
            }
            WorkflowJob workflow = oozieClient.getJobInfo(subWorkflowId);
            String consoleUrl = workflow.getConsoleUrl();
            context.setStartData(subWorkflowId, oozieUri, consoleUrl);
            if (runningJobId != null) {
                this.check(context, action);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            String externalStatus = action.getExternalStatus();
            WorkflowAction.Status status = externalStatus.equals("SUCCEEDED") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
            context.setEndData(status, this.getActionSignal(status));
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            String subWorkflowId = action.getExternalId();
            String oozieUri = action.getTrackerUri();
            OozieClient oozieClient = this.getWorkflowClient(context, oozieUri);
            WorkflowJob subWorkflow = oozieClient.getJobInfo(subWorkflowId);
            WorkflowJob.Status status = subWorkflow.getStatus();
            switch (status) {
                case FAILED: 
                case KILLED: 
                case SUCCEEDED: {
                    context.setExecutionData(status.toString(), null);
                    break;
                }
                default: {
                    context.setExternalStatus(status.toString());
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            String subWorkflowId = action.getExternalId();
            String oozieUri = action.getTrackerUri();
            OozieClient oozieClient = this.getWorkflowClient(context, oozieUri);
            oozieClient.kill(subWorkflowId);
            context.setEndData(WorkflowAction.Status.KILLED, this.getActionSignal(WorkflowAction.Status.KILLED));
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return FINAL_STATUS.contains(externalStatus);
    }

    static {
        String[] badUserProps = new String[]{"DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        String[] badDefaultProps = new String[]{"user.name"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
        FINAL_STATUS = new HashSet<String>();
        FINAL_STATUS.add("SUCCEEDED");
        FINAL_STATUS.add("KILLED");
        FINAL_STATUS.add("FAILED");
    }
}

