/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Properties;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionCheckXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CompletedActionXCommand
extends WorkflowXCommand<Void> {
    private final String actionId;
    private final String externalStatus;
    private JPAService jpaService;
    private WorkflowActionBean wfactionBean;

    public CompletedActionXCommand(String actionId, String externalStatus, Properties actionData, int priority) {
        super("callback", "callback", priority);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.externalStatus = ParamChecker.notEmpty(externalStatus, "externalStatus");
    }

    public CompletedActionXCommand(String actionId, String externalStatus, Properties actionData) {
        this(actionId, externalStatus, actionData, 1);
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        super.eagerLoadState();
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfactionBean = this.jpaService.execute(new WorkflowActionGetJPAExecutor(this.actionId));
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
        LogUtils.setLogInfo(this.wfactionBean, this.logInfo);
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        super.eagerVerifyPrecondition();
        if (this.wfactionBean.getStatus() != WorkflowAction.Status.RUNNING) {
            throw new CommandException(ErrorCode.E0800, this.actionId, this.wfactionBean.getStatus());
        }
    }

    @Override
    protected Void execute() throws CommandException {
        ActionExecutor executor = Services.get().get(ActionService.class).getExecutor(this.wfactionBean.getType());
        if (executor.isCompleted(this.externalStatus)) {
            this.queue(new ActionCheckXCommand(this.wfactionBean.getId(), this.getPriority(), -1));
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        this.eagerLoadState();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.eagerVerifyPrecondition();
    }
}

