/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BulkUpdateDeleteJPAExecutor
implements JPAExecutor<Void> {
    private Collection<JsonBean> updateList;
    private Collection<JsonBean> deleteList;
    private boolean forRerun = true;

    public BulkUpdateDeleteJPAExecutor(Collection<JsonBean> updateList, Collection<JsonBean> deleteList, boolean forRerun) {
        this.updateList = updateList;
        this.deleteList = deleteList;
        this.forRerun = forRerun;
    }

    public BulkUpdateDeleteJPAExecutor() {
    }

    public void setUpdateList(Collection<JsonBean> updateList) {
        this.updateList = updateList;
    }

    public void setDeleteList(Collection<JsonBean> deleteList) {
        this.deleteList = deleteList;
    }

    public void setForRerun(boolean forRerun) {
        this.forRerun = forRerun;
    }

    @Override
    public String getName() {
        return "BulkUpdateDeleteJPAExecutor";
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            if (this.updateList != null) {
                for (JsonBean entity : this.updateList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    em.merge((Object)entity);
                }
            }
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.deleteList != null) {
                for (JsonBean entity : this.deleteList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    if (this.forRerun) {
                        em.remove(em.merge((Object)entity));
                        continue;
                    }
                    if (entity instanceof CoordinatorActionBean) {
                        Query g = em.createNamedQuery("DELETE_UNSCHEDULED_ACTION");
                        String coordActionId = ((CoordinatorActionBean)entity).getId();
                        g.setParameter("id", (Object)coordActionId);
                        int actionsDeleted = g.executeUpdate();
                        if (actionsDeleted != 0) continue;
                        throw new JPAExecutorException(ErrorCode.E1022, coordActionId);
                    }
                    em.remove(em.merge((Object)entity));
                }
            }
            return null;
        }
        catch (JPAExecutorException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

