/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.sidewiki;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.sidewiki.SidewikiEntryFeed;
import com.google.gdata.data.sidewiki.SidewikiUserFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class SidewikiService
extends GoogleService {
    public static final String SIDEWIKI_SERVICE = "annotateweb";
    public static final String SIDEWIKI_SERVICE_VERSION = "GSidewiki-Java/" + SidewikiService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(SidewikiService.class, Versions.V2);

    public SidewikiService(String applicationName) {
        super(SIDEWIKI_SERVICE, applicationName);
        this.declareExtensions();
    }

    public SidewikiService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public SidewikiService(String applicationName, String protocol, String domainName) {
        super(SIDEWIKI_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return SIDEWIKI_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(SidewikiService.class);
    }

    private void declareExtensions() {
        new SidewikiEntryFeed().declareExtensions(this.extProfile);
        new SidewikiUserFeed().declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(SidewikiService.class, "1.0", Service.Versions.V1);
        public static final Version V2 = new Version(SidewikiService.class, "2.0", Service.Versions.V2);
        public static final Version V2_1 = new Version(SidewikiService.class, "2.1", Service.Versions.V2);

        private Versions() {
        }
    }
}

