/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaDescription;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaPlayer;
import com.google.gdata.data.media.mediarss.MediaRating;
import com.google.gdata.data.media.mediarss.MediaRestriction;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.media.mediarss.MediaTitle;
import com.google.gdata.data.youtube.YouTubeMediaContent;
import com.google.gdata.data.youtube.YouTubeMediaCredit;
import com.google.gdata.data.youtube.YouTubeMediaRating;
import com.google.gdata.data.youtube.YtAspectRatio;
import com.google.gdata.data.youtube.YtDuration;
import com.google.gdata.data.youtube.YtPrivate;
import com.google.gdata.data.youtube.YtUploaded;
import com.google.gdata.data.youtube.YtVideoId;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="media", nsUri="http://search.yahoo.com/mrss/", localName="group")
public class YouTubeMediaGroup
extends MediaGroup {
    private static final String UPLOADER_ROLE = "uploader";

    public String getVideoId() {
        YtVideoId videoId = this.getExtension(YtVideoId.class);
        return videoId == null ? null : videoId.getVideoId();
    }

    public void setVideoId(String videoId) {
        if (videoId == null) {
            this.removeExtension(YtVideoId.class);
        } else {
            this.setExtension(new YtVideoId(videoId));
        }
    }

    public Long getDuration() {
        YtDuration duration = this.getExtension(YtDuration.class);
        return duration == null ? null : Long.valueOf(duration.getSeconds());
    }

    public void setDuration(Long seconds) {
        if (seconds == null) {
            this.removeExtension(YtDuration.class);
        } else {
            YtDuration duration = new YtDuration();
            duration.setSeconds(seconds);
            this.setExtension(duration);
        }
    }

    public DateTime getUploaded() {
        YtUploaded uploadTime = this.getExtension(YtUploaded.class);
        return uploadTime != null ? uploadTime.getDateTime() : null;
    }

    public void setUploaded(DateTime dateTime) {
        if (dateTime == null) {
            this.removeExtension(YtUploaded.class);
        } else {
            this.setExtension(new YtUploaded(dateTime));
        }
    }

    public void setUploader(String uploader) {
        Iterator<YouTubeMediaCredit> iterator = this.getYouTubeCredits().iterator();
        while (iterator.hasNext()) {
            MediaCredit credit = iterator.next();
            if (!UPLOADER_ROLE.equals(credit.getRole()) || !"urn:youtube".equals(credit.getScheme())) continue;
            iterator.remove();
        }
        if (uploader != null) {
            YouTubeMediaCredit credit = new YouTubeMediaCredit();
            credit.setScheme("urn:youtube");
            credit.setRole(UPLOADER_ROLE);
            credit.setContent(uploader);
            this.addCredit(credit);
        }
    }

    public String getUploader() {
        YouTubeMediaCredit uploader = this.getUploaderTag();
        return uploader == null ? null : uploader.getContent();
    }

    public YouTubeMediaCredit.Type getUploaderType() {
        YouTubeMediaCredit uploader = this.getUploaderTag();
        return uploader == null ? null : uploader.getType();
    }

    private YouTubeMediaCredit getUploaderTag() {
        for (YouTubeMediaCredit credit : this.getYouTubeCredits()) {
            if (!UPLOADER_ROLE.equals(credit.getRole()) || !"urn:youtube".equals(credit.getScheme())) continue;
            return credit;
        }
        return null;
    }

    public List<YouTubeMediaContent> getYouTubeContents() {
        return this.getRepeatingExtension(YouTubeMediaContent.class);
    }

    @Override
    public void addContent(MediaContent content) {
        if (!(content instanceof YouTubeMediaContent)) {
            throw new IllegalArgumentException("YouTube entries requires YouTubeMediaContent");
        }
        super.addContent(content);
    }

    @Override
    public List<MediaContent> getContents() {
        final List<YouTubeMediaContent> contents = this.getYouTubeContents();
        return new AbstractList<MediaContent>(){

            @Override
            public MediaContent get(int index) {
                return (MediaContent)contents.get(index);
            }

            @Override
            public int size() {
                return contents.size();
            }
        };
    }

    @Override
    public void clearContents() {
        this.getYouTubeContents().clear();
    }

    public void addContent(YouTubeMediaContent content) {
        this.addRepeatingExtension(content);
    }

    public List<YouTubeMediaRating> getYouTubeRatings() {
        return this.getRepeatingExtension(YouTubeMediaRating.class);
    }

    @Override
    public void addRating(MediaRating rating) {
        if (!(rating instanceof YouTubeMediaRating)) {
            throw new IllegalArgumentException("YouTube entries requires YouTubeMediaRating");
        }
        super.addRating(rating);
    }

    @Override
    public List<MediaRating> getRatings() {
        final List<YouTubeMediaRating> ratings = this.getYouTubeRatings();
        return new AbstractList<MediaRating>(){

            @Override
            public MediaRating get(int index) {
                return (MediaRating)ratings.get(index);
            }

            @Override
            public int size() {
                return ratings.size();
            }
        };
    }

    @Override
    public void clearRatings() {
        this.getYouTubeRatings().clear();
    }

    public void addRating(YouTubeMediaRating rating) {
        this.addRepeatingExtension(rating);
    }

    public List<YouTubeMediaCredit> getYouTubeCredits() {
        return this.getRepeatingExtension(YouTubeMediaCredit.class);
    }

    @Override
    public void addCredit(MediaCredit credit) {
        if (!(credit instanceof YouTubeMediaCredit)) {
            throw new IllegalArgumentException("YouTube entries requires YouTubeMediaCredit");
        }
        super.addCredit(credit);
    }

    @Override
    public List<MediaCredit> getCredits() {
        final List<YouTubeMediaCredit> credits = this.getYouTubeCredits();
        return new AbstractList<MediaCredit>(){

            @Override
            public MediaCredit get(int index) {
                return (MediaCredit)credits.get(index);
            }

            @Override
            public int size() {
                return credits.size();
            }
        };
    }

    @Override
    public void clearCredits() {
        this.getYouTubeCredits().clear();
    }

    public void addCredit(YouTubeMediaCredit credit) {
        this.addRepeatingExtension(credit);
    }

    public void setAspectRatio(YtAspectRatio aspectRatio) {
        if (aspectRatio == null) {
            this.removeExtension(YtAspectRatio.class);
        } else {
            this.setExtension(aspectRatio);
        }
    }

    public YtAspectRatio getAspectRatio() {
        return this.getExtension(YtAspectRatio.class);
    }

    public boolean isPrivate() {
        YtPrivate privacyLevel = this.getExtension(YtPrivate.class);
        return privacyLevel != null;
    }

    public void setPrivate(boolean makePrivate) {
        if (makePrivate) {
            this.setExtension(new YtPrivate());
        } else {
            this.removeExtension(YtPrivate.class);
        }
    }

    public MediaCategory getYouTubeCategory() {
        Set<MediaCategory> found = this.getCategoriesWithScheme("http://gdata.youtube.com/schemas/2007/categories.cat");
        if (found.size() == 1) {
            return found.iterator().next();
        }
        if (found.size() > 1) {
            return null;
        }
        Set<MediaCategory> withNoScheme = this.getCategoriesWithScheme(null);
        if (withNoScheme.size() == 1) {
            return withNoScheme.iterator().next();
        }
        return null;
    }

    public void setYouTubeCategory(String name) {
        Iterator<MediaCategory> iterator = this.getCategories().iterator();
        while (iterator.hasNext()) {
            MediaCategory category = iterator.next();
            if (!"http://gdata.youtube.com/schemas/2007/categories.cat".equals(category.getScheme())) continue;
            iterator.remove();
        }
        this.addCategory(new MediaCategory("http://gdata.youtube.com/schemas/2007/categories.cat", name));
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(YouTubeMediaGroup.class, YtAspectRatio.class);
        extProfile.declare(YouTubeMediaGroup.class, YtVideoId.class);
        extProfile.declare(YouTubeMediaGroup.class, YtDuration.class);
        extProfile.declare(YouTubeMediaGroup.class, YtPrivate.class);
        extProfile.declare(YouTubeMediaGroup.class, YtUploaded.class);
        extProfile.declare(YouTubeMediaGroup.class, YouTubeMediaContent.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaPlayer.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaKeywords.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaTitle.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaDescription.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaRestriction.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaCategory.class);
        extProfile.declare(YouTubeMediaGroup.class, MediaThumbnail.class);
        extProfile.declare(YouTubeMediaGroup.class, YouTubeMediaRating.class);
        extProfile.declare(YouTubeMediaGroup.class, YouTubeMediaCredit.class);
        extProfile.declareArbitraryXmlExtension(YouTubeMediaGroup.class);
    }
}

