/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.platform.plugin.kettle.messages.Messages;

public class EngineMetaLoader {
    private static final Log log = LogFactory.getLog(EngineMetaLoader.class);
    private Repository repository;

    public EngineMetaLoader(Repository repository) {
        this.repository = repository;
    }

    public TransMeta loadTransMeta(String directory, String filename) throws FileNotFoundException {
        if (directory == null || filename == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("EngineMetaLoader.ERROR_0001_DIR_OR_FILENAME_NULL"));
        }
        return this.load(directory, filename, TransMeta.class);
    }

    public JobMeta loadJobMeta(String directory, String filename) throws FileNotFoundException {
        if (directory == null || filename == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("EngineMetaLoader.ERROR_0001_DIR_OR_FILENAME_NULL"));
        }
        return this.load(directory, filename, JobMeta.class);
    }

    private <T> T load(String directoryName, String fileName, Class<T> metaType) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("attempting to load dir: {0} file: {1} from repository: {2}", directoryName, fileName, this.repository == null ? "" : this.repository.getName()));
        }
        Object meta = null;
        try {
            if (this.repository != null) {
                RepositoryDirectoryInterface directory = this.repository.loadRepositoryDirectoryTree().findDirectory(directoryName);
                meta = metaType == TransMeta.class ? this.repository.loadTransformation(fileName, directory, null, true, null) : this.repository.loadJob(fileName, directory, null, null);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Repository is null!");
                this.dumpRepositoryNames();
            }
        }
        catch (Exception e) {
            log.error((Object)MessageFormat.format("Using the new Repository API, we could not find dir: {0} file: {1} in repository: {2}", directoryName, fileName, this.repository == null ? "" : this.repository.getName()), (Throwable)e);
        }
        if (meta == null) {
            try {
                meta = metaType == TransMeta.class ? new TransMeta(directoryName + "/" + fileName, this.repository) : new JobMeta(directoryName + "/" + fileName, this.repository);
            }
            catch (KettleException e) {
                log.error((Object)MessageFormat.format("Using the old Repository API, failed to open file: {0}/{1} in repository: {2}", directoryName, fileName, this.repository == null ? "" : this.repository.getName()), (Throwable)e);
            }
        }
        if (meta == null) {
            String message = MessageFormat.format(Messages.getInstance().getErrorString("EngineMetaLoader.ERROR_0002_PDI_FILE_NOT_FOUND"), directoryName, fileName, this.repository == null ? "" : this.repository.getName());
            throw new FileNotFoundException(message);
        }
        return (T)meta;
    }

    private void dumpRepositoryNames() {
        try {
            RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
            repositoriesMeta.readData();
            for (int i = 0; i < repositoriesMeta.nrRepositories(); ++i) {
                RepositoryMeta repoMeta = repositoriesMeta.getRepository(i);
                log.debug((Object)("Found repo: " + repoMeta.getName() + " type: " + repoMeta.getClass().getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

