/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.kettle.PlatformKettleDataSourceProvider;
import org.pentaho.platform.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KettleSystemListener
implements IPentahoSystemListener {
    private boolean usePlatformLogFile = true;

    public boolean startup(IPentahoSession session) {
        if (this.usePlatformLogFile) {
            this.initLogging();
        }
        this.hookInDataSourceProvider();
        System.setProperty("KETTLE_PLUGIN_BASE_FOLDERS", Const.DEFAULT_PLUGIN_BASE_FOLDERS + "," + PentahoSystem.getApplicationContext().getSolutionPath("system/kettle/plugins"));
        try {
            KettleSystemListener.environmentInit(session);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Logger.error((String)KettleSystemListener.class.getName(), (String)Messages.getInstance().getErrorString("KettleSystemListener.ERROR_0001_PLUGIN_LOAD_FAILED"));
        }
        try {
            String slaveServerConfigFilename = "system" + File.separator + "kettle" + File.separator + "slave-server-config.xml";
            File slaveServerConfigFile = new File(PentahoSystem.getApplicationContext().getSolutionPath(slaveServerConfigFilename));
            if (slaveServerConfigFile.exists()) {
                FileInputStream is = new FileInputStream(slaveServerConfigFile);
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                Node configNode = XMLHandler.getSubNode((Node)document, (String)"slave_config");
                SlaveServerConfig config = new SlaveServerConfig((LogChannelInterface)new LogChannel((Object)"Slave server config"), configNode);
                config.setFilename(slaveServerConfigFilename);
                SlaveServer slaveServer = new SlaveServer();
                config.setSlaveServer(slaveServer);
                CarteSingleton.setSlaveServerConfig((SlaveServerConfig)config);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Logger.error((String)KettleSystemListener.class.getName(), (String)t.getMessage());
        }
        return true;
    }

    protected void initLogging() {
        Enumeration appenders = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            LogWriter.getInstance().addAppender(appender);
        }
    }

    private void hookInDataSourceProvider() {
        try {
            Class<?> clazz = Class.forName("org.pentaho.di.core.database.DataSourceProviderInterface");
            PlatformKettleDataSourceProvider.hookupProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readProperties(IPentahoSession session) {
        Properties props = new Properties();
        String kettlePropsFilename = "system" + File.separator + "kettle" + File.separator + "kettle.properties";
        InputStream is = null;
        try {
            File kettlePropsFile = new File(PentahoSystem.getApplicationContext().getSolutionPath(kettlePropsFilename));
            if (!kettlePropsFile.exists()) {
                Properties properties = props;
                return properties;
            }
            is = ActionSequenceResource.getInputStream((String)kettlePropsFilename, null);
            props.load(is);
        }
        catch (IOException ioe) {
            Logger.error((String)KettleSystemListener.class.getName(), (String)(Messages.getInstance().getString("KettleSystemListener.ERROR_0003_PROPERTY_FILE_READ_FAILED") + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        props.put("pentaho.solutionpath", PentahoSystem.getApplicationContext().getFileOutputPath(""));
        return props;
    }

    public static void environmentInit(IPentahoSession session) throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    public void shutdown() {
    }

    public void setUsePlatformLogFile(boolean usePlatformLogFile) {
        this.usePlatformLogFile = usePlatformLogFile;
    }
}

