/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.plugin.kettle.PdiAction;
import org.pentaho.platform.web.http.api.resources.FileResourceContentGenerator;

public class PdiContentGenerator
extends FileResourceContentGenerator {
    private static final Log logger = LogFactory.getLog(PdiContentGenerator.class);
    private OutputStream out;
    private RepositoryFile repositoryFile;

    public String getMimeType(String streamPropertyName) {
        return "text/html";
    }

    public void execute() throws Exception {
        PdiAction pdiComponent = new PdiAction();
        pdiComponent.setDirectory(FilenameUtils.getPathNoEndSeparator((String)this.repositoryFile.getPath()));
        if (this.repositoryFile.getName().toLowerCase().endsWith(".ktr")) {
            pdiComponent.setTransformation(FilenameUtils.getBaseName((String)this.repositoryFile.getPath()));
        } else if (this.repositoryFile.getName().toLowerCase().endsWith(".kjb")) {
            pdiComponent.setJob(FilenameUtils.getBaseName((String)this.repositoryFile.getPath()));
        }
        pdiComponent.execute();
        this.out.write("<html><head/><body>\n".getBytes());
        this.out.write("<p/><pre>\n".getBytes());
        this.out.write(pdiComponent.getLog().getBytes());
        this.out.write("</pre></body>\n".getBytes());
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    public void setRepositoryFile(RepositoryFile repositoryFile) {
        this.repositoryFile = repositoryFile;
    }
}

