/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFileMetaProvider;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.w3c.XmlW3CHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PdiFileInfo
implements ISolutionFileMetaProvider {
    private Log logger = LogFactory.getLog(PdiFileInfo.class);

    public IFileInfo getFileInfo(ISolutionFile solutionFile, InputStream in) {
        try {
            String filename = solutionFile.getFileName();
            String xml = IOUtils.toString((InputStream)in, (String)"UTF-8");
            Document doc = XmlW3CHelper.getDomFromString((String)xml);
            Node root = doc.getFirstChild();
            if (filename.toLowerCase().endsWith(".ktr")) {
                TransMeta transMeta = new TransMeta(root, null);
                FileInfo info = new FileInfo();
                info.setAuthor(transMeta.getCreatedUser());
                info.setDescription(transMeta.getDescription());
                info.setDisplayType("pdi-transformation");
                info.setIcon(null);
                info.setTitle(transMeta.getName());
                return info;
            }
            if (filename.toLowerCase().endsWith(".kjb")) {
                JobMeta jobMeta = new JobMeta(root, null, null);
                FileInfo info = new FileInfo();
                info.setAuthor(jobMeta.getCreatedUser());
                info.setDescription(jobMeta.getDescription());
                info.setDisplayType("pdi-job");
                info.setIcon(null);
                info.setTitle(jobMeta.getName());
                return info;
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)Messages.getInstance().getErrorString("PdiFileInfo.ERROR_0001_PARSING_DOCUMENT", new Object[]{solutionFile.getFullPath()}), (Throwable)e);
            return null;
        }
    }
}

