/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle.messages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.messages.MessageUtil;

public class Messages {
    private static final String BUNDLE_NAME = Messages.class.getPackage().getName() + ".messages";
    private static final Map<Locale, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());
    private static Messages instance = new Messages();

    protected static Map<Locale, ResourceBundle> getLocales() {
        return locales;
    }

    public static Messages getInstance() {
        return instance;
    }

    private static ResourceBundle getBundle() {
        Locale locale = LocaleHelper.getLocale();
        ResourceBundle bundle = locales.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            locales.put(locale, bundle);
        }
        return bundle;
    }

    public static String getEncodedString(String rawValue) {
        if (rawValue == null) {
            return "";
        }
        StringBuffer value = new StringBuffer();
        for (int n = 0; n < rawValue.length(); ++n) {
            char charValue = rawValue.charAt(n);
            if (charValue >= '\u0080') {
                value.append("&#x");
                value.append(Integer.toString(charValue, 16));
                value.append(";");
                continue;
            }
            value.append(charValue);
        }
        return value.toString();
    }

    public String getString(String key) {
        try {
            return Messages.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public String getString(String key, String ... params) {
        return MessageUtil.getString((ResourceBundle)Messages.getBundle(), (String)key, (Object[])params);
    }

    public String getErrorString(String key) {
        return MessageUtil.formatErrorMessage((String)key, (String)this.getString(key));
    }

    public String getErrorString(String key, String ... params) {
        return MessageUtil.getErrorString((ResourceBundle)Messages.getBundle(), (String)key, (Object[])params);
    }
}

