/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import pt.webdetails.cpf.SimpleContentGenerator;

public abstract class SpringEnabledContentGenerator
extends SimpleContentGenerator {
    private static final Log logger = LogFactory.getLog(SpringEnabledContentGenerator.class);
    protected IPluginManager pm = (IPluginManager)PentahoSystem.get(IPluginManager.class);
    protected static ConfigurableApplicationContext pluginContext;

    public SpringEnabledContentGenerator() {
        if (pluginContext == null) {
            pluginContext = this.getSpringBeanFactory();
        }
    }

    private ConfigurableApplicationContext getSpringBeanFactory() {
        final PluginClassLoader loader = (PluginClassLoader)this.pm.getClassLoader(this.getPluginName());
        logger.warn((Object)loader.getPluginDir());
        File f = new File(loader.getPluginDir(), "plugin.spring.xml");
        if (f.exists()) {
            logger.debug((Object)("Found plugin spring file @ " + f.getAbsolutePath()));
            FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext("file:" + f.getAbsolutePath()){

                protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
                    beanDefinitionReader.setBeanClassLoader((ClassLoader)loader);
                }

                protected void prepareBeanFactory(ConfigurableListableBeanFactory clBeanFactory) {
                    super.prepareBeanFactory(clBeanFactory);
                    clBeanFactory.setBeanClassLoader((ClassLoader)loader);
                }

                public ClassLoader getClassLoader() {
                    return loader;
                }
            };
            return context;
        }
        throw new IllegalStateException("no plugin.spring.xml file found");
    }
}

