/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.persistence;

import java.text.MessageFormat;
import pt.webdetails.cpf.persistence.Filter;
import pt.webdetails.cpf.persistence.Item;

public class Constraint
implements Item {
    static final String BETWEEN = "({0} > {1} and {0} < {2})";
    static final String GT = "{0} > {1}";
    static final String LT = "{0} < {1}";
    static final String EQ = "{0} = {1}";
    static final String NE = "{0} != {1}";
    Filter parent;
    String parameter;
    String filter;

    public Constraint(Filter parent, String parameter) {
        this.parent = parent;
        this.parameter = parameter;
    }

    private Filter constraint(String templ, Object ... values) {
        this.filter = MessageFormat.format(templ, values);
        this.parent.addConstraint(this);
        return this.parent;
    }

    public Filter between(Number min, Number max) {
        return this.constraint(BETWEEN, this.parameter, min, max);
    }

    public Filter greaterThan(Number min) {
        return this.constraint(GT, this.parameter, min);
    }

    public Filter lessThan(Number min) {
        return this.constraint(LT, this.parameter, min);
    }

    public Filter equalTo(Object obj) {
        String v = obj.toString();
        v = "\"" + v.replaceAll("\"", "\\\"") + "\"";
        return this.constraint(EQ, this.parameter, v);
    }

    public Filter notEqualTo(Object obj) {
        String v = obj.toString();
        v = "\"" + v.replaceAll("\"", "\\\\\"") + "\"";
        return this.constraint(NE, this.parameter, v);
    }

    public String toString() {
        return this.filter;
    }
}

