/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.webdetails.cpf.VersionChecker;
import pt.webdetails.cpf.plugin.CorePlugin;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.XmlDom4JUtils;

public class Plugin
extends CorePlugin {
    private String description;
    private String company;
    private String companyUrl;
    private String companyLogo;
    private String path;
    private String version;
    private final String PLUGIN_XML_FILENAME = "plugin.xml";
    private final String SETTINGS_XML_FILENAME = "settings.xml";
    private final String VERSION_XML_FILENAME = "version.xml";
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IReadAccess pluginDirAccess;

    public Plugin(String id, IReadAccess pluginSysDir) {
        super(id);
        this.pluginSelfBuild(pluginSysDir);
    }

    @JsonIgnore
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @JsonProperty(value="companyUrl")
    public String getCompanyUrl() {
        return this.companyUrl;
    }

    public void setCompanyUrl(String companyUrl) {
        this.companyUrl = companyUrl;
    }

    @JsonProperty(value="companyLogo")
    public String getCompanyLogo() {
        return this.companyLogo;
    }

    public void setCompanyLogo(String companyLogo) {
        this.companyLogo = companyLogo;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    private void pluginSelfBuild(IReadAccess access) {
        this.pluginDirAccess = access;
        try {
            if (this.hasPluginXML()) {
                Element documentNode = XmlDom4JUtils.getDocumentFromFile((IReadAccess)access, (String)"plugin.xml").getRootElement();
                String pluginName = documentNode.valueOf("/plugin/@name");
                this.setName(pluginName);
                this.setDescription(documentNode.valueOf("/plugin/content-types/content-type/description"));
                this.setCompany(documentNode.valueOf("/plugin/content-types/content-type/company/@name"));
                this.setCompanyUrl(documentNode.valueOf("/plugin/content-types/content-type/company/@url"));
                this.setCompanyLogo(documentNode.valueOf("/plugin/content-types/content-type/company/@logo"));
            }
            if (this.hasVersionXML()) {
                Document versionDoc = XmlDom4JUtils.getDocumentFromFile((IReadAccess)access, (String)"version.xml");
                this.version = new VersionChecker.Version(versionDoc).toString();
            } else {
                String unspecified;
                this.version = unspecified = "unspecified or no version.xml present in plugin directory";
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    @JsonIgnore
    public Node getRegisteredEntities(String entityName) {
        if (this.hasSettingsXML()) {
            try {
                Document documentNode = XmlDom4JUtils.getDocumentFromFile((IReadAccess)this.pluginDirAccess, (String)"settings.xml");
                return documentNode.selectSingleNode("/settings" + entityName);
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
        return null;
    }

    @JsonIgnore
    public List<Element> getSettingsSection(String xpath) {
        if (this.hasSettingsXML()) {
            try {
                Document documentNode = XmlDom4JUtils.getDocumentFromFile((IReadAccess)this.pluginDirAccess, (String)"settings.xml");
                return documentNode.selectNodes("/settings" + xpath);
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
        return Collections.emptyList();
    }

    @JsonIgnore
    public boolean hasPluginXML() {
        return this.pluginDirAccess.fileExists("plugin.xml");
    }

    @JsonIgnore
    public boolean hasSettingsXML() {
        return this.pluginDirAccess.fileExists("settings.xml");
    }

    @JsonIgnore
    public boolean hasVersionXML() {
        return this.pluginDirAccess.fileExists("version.xml");
    }

    @JsonIgnore
    public String getPluginJson() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    @JsonIgnore
    public String getXmlValue(String xpathExpression, String fileName) {
        try {
            Document documentRoot = XmlDom4JUtils.getDocumentFromFile((IReadAccess)this.pluginDirAccess, (String)fileName);
            return documentRoot != null ? documentRoot.valueOf(xpathExpression) : null;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            return null;
        }
    }

    public String getVersion() {
        return this.version.toString();
    }
}

