/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.plugins;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.plugins.IPluginFilter;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class PluginsAnalyzer {
    private List<Plugin> installedPlugins;
    protected Log logger = LogFactory.getLog(this.getClass());
    IPluginManager pluginManager;
    IContentAccessFactory repositoryAccess;

    public PluginsAnalyzer() {
        try {
            PentahoPluginEnvironment.getInstance();
            this.setFactory(PentahoPluginEnvironment.repository());
        }
        catch (NullPointerException npe) {
            this.setFactory(null);
        }
        this.setPluginManager((IPluginManager)PentahoSystem.get(IPluginManager.class));
    }

    private void setFactory(IContentAccessFactory factory) {
        this.repositoryAccess = factory;
    }

    private void setPluginManager(IPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public PluginsAnalyzer(IContentAccessFactory factory, IPluginManager pluginManager) {
        this.repositoryAccess = factory;
        this.pluginManager = pluginManager;
    }

    public void refresh() {
        this.buildPluginsList();
    }

    public List<Plugin> getInstalledPlugins() {
        return this.installedPlugins;
    }

    public List<PluginWithEntity> getRegisteredEntities(String xpath) {
        ArrayList<PluginWithEntity> result = new ArrayList<PluginWithEntity>();
        for (Plugin plugin : this.installedPlugins) {
            Node registeredEntity = plugin.getRegisteredEntities(xpath);
            if (registeredEntity == null) continue;
            result.add(new PluginWithEntity(plugin, registeredEntity));
        }
        return result;
    }

    public List<PluginPair<List<Element>>> getPluginsWithSection(String xpath) {
        ArrayList<PluginPair<List<Element>>> pluginsWithSection = new ArrayList<PluginPair<List<Element>>>();
        for (Plugin plugin : this.installedPlugins) {
            List<Element> section = plugin.getSettingsSection(xpath);
            if (section.isEmpty()) continue;
            pluginsWithSection.add(new PluginPair<List<Element>>(plugin, section));
        }
        return pluginsWithSection;
    }

    private void buildPluginsList() {
        List registeredPluginIds = this.pluginManager.getRegisteredPlugins();
        this.installedPlugins = new ArrayList<Plugin>(registeredPluginIds.size());
        for (String pluginId : registeredPluginIds) {
            IReadAccess pluginDir = this.repositoryAccess.getOtherPluginSystemReader(pluginId, null);
            Plugin plugin = new Plugin(pluginId, pluginDir);
            this.installedPlugins.add(plugin);
        }
    }

    public List<Plugin> getPlugins(IPluginFilter filter) {
        ArrayList<Plugin> pluginsList = new ArrayList<Plugin>();
        for (Plugin plugin : this.installedPlugins) {
            if (!filter.include(plugin)) continue;
            pluginsList.add(plugin);
        }
        return pluginsList;
    }

    public class PluginPair<T> {
        private T value;
        private Plugin plugin;

        public Plugin getPlugin() {
            return this.plugin;
        }

        public T getValue() {
            return this.value;
        }

        public PluginPair(Plugin plugin, T value) {
            this.value = value;
            this.plugin = plugin;
        }
    }

    public class PluginWithEntity {
        private Plugin plugin;
        private Node registeredEntity;

        public PluginWithEntity(Plugin plugin, Node registeredEntity) {
            this.plugin = plugin;
            this.registeredEntity = registeredEntity;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public Node getRegisteredEntity() {
            return this.registeredEntity;
        }
    }
}

