/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.pentaho.unified;

import java.util.EnumSet;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.api.IUserContentAccessExtended;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.pentaho.unified.UnifiedRepositoryAccess;

public class UserContentRepositoryAccess
extends UnifiedRepositoryAccess
implements IUserContentAccessExtended {
    private IUnifiedRepository repository;
    private IPentahoSession session;
    private static final String DEFAULT_USER_DIR = "/";

    public UserContentRepositoryAccess(IPentahoSession session) {
        this(session, DEFAULT_USER_DIR);
    }

    public UserContentRepositoryAccess(IPentahoSession pentahoSession, String startPath) {
        this.session = pentahoSession;
        this.initRepository();
        this.basePath = StringUtils.isEmpty((String)startPath) ? DEFAULT_USER_DIR : startPath;
    }

    protected IUnifiedRepository initRepository() {
        return (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)this.session);
    }

    @Override
    protected IUnifiedRepository getRepository() {
        if (this.repository == null) {
            this.repository = this.initRepository();
        }
        return this.repository;
    }

    public boolean hasAccess(String path, FileAccess access) {
        String normalizedPath = Util.joinPath((String[])new String[]{this.basePath, path});
        return this.getRepository().hasAccess(normalizedPath, UserContentRepositoryAccess.toRepositoryFilePermissions(access));
    }

    protected static EnumSet<RepositoryFilePermission> toRepositoryFilePermissions(FileAccess access) {
        switch (access) {
            case READ: 
            case EXECUTE: {
                return EnumSet.of(RepositoryFilePermission.READ);
            }
            case WRITE: {
                return EnumSet.of(RepositoryFilePermission.WRITE);
            }
            case DELETE: {
                return EnumSet.of(RepositoryFilePermission.DELETE);
            }
        }
        return EnumSet.of(RepositoryFilePermission.ALL);
    }
}

