/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class ByteWritable
implements WritableComparable {
    private int value;

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    public ByteWritable(int b) {
        this.value = b & 0xFF;
    }

    public ByteWritable() {
        this.value = 0;
    }

    public void set(int b) {
        this.value = b & 0xFF;
    }

    public int compareTo(Object o) {
        int thisValue = this.value;
        int thatValue = ((ByteWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteWritable)) {
            return false;
        }
        ByteWritable that = (ByteWritable)o;
        if (this == that) {
            return true;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        WritableComparator.define(ByteWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ByteWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return 0;
        }
    }
}

