/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.mapred.InputFormat;

@Explain(displayName="Partition")
public class PartitionDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private TableDesc tableDesc;
    private LinkedHashMap<String, String> partSpec;
    private Class<? extends Deserializer> deserializerClass;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends HiveOutputFormat> outputFileFormatClass;
    private Properties properties;
    private String serdeClassName;
    private transient String baseFileName;

    public void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    public PartitionDesc() {
    }

    public PartitionDesc(TableDesc table, LinkedHashMap<String, String> partSpec) {
        this(table, partSpec, null, null, null, null, null);
    }

    public PartitionDesc(TableDesc table, LinkedHashMap<String, String> partSpec, Class<? extends Deserializer> serdeClass, Class<? extends InputFormat> inputFileFormatClass, Class<?> outputFormat, Properties properties, String serdeClassName) {
        this.tableDesc = table;
        this.properties = properties;
        this.partSpec = partSpec;
        this.deserializerClass = serdeClass;
        this.inputFileFormatClass = inputFileFormatClass;
        if (outputFormat != null) {
            this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFormat);
        }
        if (serdeClassName != null) {
            this.serdeClassName = serdeClassName;
        } else if (properties != null) {
            this.serdeClassName = properties.getProperty("serialization.lib");
        }
    }

    public PartitionDesc(Partition part) throws HiveException {
        this.tableDesc = Utilities.getTableDesc(part.getTable());
        this.properties = part.getMetadataFromPartitionSchema();
        this.partSpec = part.getSpec();
        this.deserializerClass = part.getDeserializer(this.properties).getClass();
        this.inputFileFormatClass = part.getInputFormatClass();
        this.outputFileFormatClass = part.getOutputFormatClass();
        this.serdeClassName = this.properties.getProperty("serialization.lib");
    }

    public PartitionDesc(Partition part, TableDesc tblDesc) throws HiveException {
        Deserializer deserializer;
        this.tableDesc = tblDesc;
        this.properties = part.getSchemaFromTableSchema(tblDesc.getProperties());
        this.partSpec = part.getSpec();
        try {
            deserializer = SerDeUtils.lookupDeserializer(this.properties.getProperty("serialization.lib"));
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        this.deserializerClass = deserializer.getClass();
        this.inputFileFormatClass = part.getInputFormatClass();
        this.outputFileFormatClass = part.getOutputFormatClass();
        this.serdeClassName = this.properties.getProperty("serialization.lib");
    }

    @Explain(displayName="")
    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Explain(displayName="partition values")
    public LinkedHashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(LinkedHashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        if (this.deserializerClass == null && this.tableDesc != null) {
            this.setDeserializerClass(this.tableDesc.getDeserializerClass());
        }
        return this.deserializerClass;
    }

    public void setDeserializerClass(Class<? extends Deserializer> serdeClass) {
        this.deserializerClass = serdeClass;
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        if (this.inputFileFormatClass == null && this.tableDesc != null) {
            this.setInputFileFormatClass(this.tableDesc.getInputFileFormatClass());
        }
        return this.inputFileFormatClass;
    }

    public Deserializer getDeserializer() throws Exception {
        Deserializer de = this.deserializerClass.newInstance();
        de.initialize(null, this.properties);
        return de;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass;
    }

    public Class<? extends HiveOutputFormat> getOutputFileFormatClass() {
        if (this.outputFileFormatClass == null && this.tableDesc != null) {
            this.setOutputFileFormatClass(this.tableDesc.getOutputFileFormatClass());
        }
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
    }

    @Explain(displayName="properties", normalExplain=false)
    public Properties getProperties() {
        if (this.properties == null && this.tableDesc != null) {
            return this.tableDesc.getProperties();
        }
        return this.properties;
    }

    public Properties getOverlayedProperties() {
        if (this.tableDesc != null) {
            Properties overlayedProps = new Properties(this.tableDesc.getProperties());
            overlayedProps.putAll((Map<?, ?>)this.getProperties());
            return overlayedProps;
        }
        return this.getProperties();
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Explain(displayName="serde")
    public String getSerdeClassName() {
        if (this.serdeClassName == null && this.tableDesc != null) {
            this.setSerdeClassName(this.tableDesc.getSerdeClassName());
        }
        return this.serdeClassName;
    }

    public void setSerdeClassName(String serdeClassName) {
        this.serdeClassName = serdeClassName;
    }

    @Explain(displayName="name")
    public String getTableName() {
        return this.getProperties().getProperty("name");
    }

    @Explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @Explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    @Explain(displayName="base file name", normalExplain=false)
    public String getBaseFileName() {
        return this.baseFileName;
    }

    public PartitionDesc clone() {
        PartitionDesc ret = new PartitionDesc();
        ret.setSerdeClassName(this.serdeClassName);
        ret.setDeserializerClass(this.deserializerClass);
        ret.inputFileFormatClass = this.inputFileFormatClass;
        ret.outputFileFormatClass = this.outputFileFormatClass;
        if (this.properties != null) {
            Properties newProp = new Properties();
            Enumeration<Object> keysProp = this.properties.keys();
            while (keysProp.hasMoreElements()) {
                Object key = keysProp.nextElement();
                newProp.put(key, this.properties.get(key));
            }
            ret.setProperties(newProp);
        }
        ret.tableDesc = (TableDesc)this.tableDesc.clone();
        if (this.partSpec != null) {
            ret.partSpec = new LinkedHashMap();
            ret.partSpec.putAll(this.partSpec);
        }
        return ret;
    }

    void deriveBaseFileName(String path) {
        PlanUtils.configureInputJobPropertiesForStorageHandler(this.tableDesc);
        if (path == null) {
            return;
        }
        try {
            Path p = new Path(path);
            this.baseFileName = p.getName();
        }
        catch (Exception ex) {
            this.baseFileName = path;
        }
    }
}

