/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.math.BigDecimal;
import java.nio.charset.CharacterCodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBigDecimalObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyBigDecimal
extends LazyPrimitive<LazyBigDecimalObjectInspector, BigDecimalWritable> {
    private static final Log LOG = LogFactory.getLog(LazyBigDecimal.class);

    public LazyBigDecimal(LazyBigDecimalObjectInspector oi) {
        super(oi);
        this.data = new BigDecimalWritable();
    }

    public LazyBigDecimal(LazyBigDecimal copy) {
        super(copy);
        this.data = new BigDecimalWritable((BigDecimalWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String byteData = null;
        try {
            byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
            ((BigDecimalWritable)this.data).set(new BigDecimal(byteData));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            LOG.debug((Object)("Data not in the BigDecimal data type range so converted to null. Given data is :" + byteData), (Throwable)e);
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
            LOG.debug((Object)"Data not in the BigDecimal data type range so converted to null.", (Throwable)e);
        }
    }

    @Override
    public BigDecimalWritable getWritableObject() {
        return (BigDecimalWritable)this.data;
    }
}

