/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;

public class Exporter {
    IUnifiedRepository unifiedRepository;
    private String repoPath;
    private String filePath;
    private File exportDir;
    protected DefaultUnifiedRepositoryWebService repoWs;

    public Exporter(IUnifiedRepository unifiedRepository) {
        this(unifiedRepository, null, null);
    }

    public Exporter(IUnifiedRepository unifiedRepository, String path) {
        this(unifiedRepository, path, null);
    }

    public Exporter(IUnifiedRepository unifiedRepository, String path, String filePath) {
        this.unifiedRepository = unifiedRepository;
        this.repoPath = path;
        this.filePath = filePath;
    }

    public void doExport() throws IOException {
        this.exportDir = new File(this.filePath);
        RepositoryFile exportRepositoryFile = this.unifiedRepository.getFile(this.repoPath);
        if (exportRepositoryFile == null) {
            throw new FileNotFoundException(Messages.getInstance().getErrorString("Exporter.ERROR_0001_INVALID_SOURCE_DIRECTORY", new Object[]{this.repoPath}));
        }
        if (exportRepositoryFile.isFolder()) {
            this.exportDirectory(exportRepositoryFile, this.exportDir);
        } else {
            this.exportFile(exportRepositoryFile, this.exportDir);
        }
    }

    public File doExportAsZip() throws IOException {
        RepositoryFile exportRepositoryFile = this.unifiedRepository.getFile(this.repoPath);
        return this.doExportAsZip(exportRepositoryFile);
    }

    public File doExportAsZip(RepositoryFile exportRepositoryFile) throws IOException {
        File zipFile = File.createTempFile("repoExport", ".zip");
        zipFile.deleteOnExit();
        this.filePath = new File(this.repoPath).getParent();
        if (exportRepositoryFile == null) {
            throw new FileNotFoundException(Messages.getInstance().getErrorString("Exporter.ERROR_0001_INVALID_SOURCE_DIRECTORY", new Object[]{this.repoPath}));
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        if (exportRepositoryFile.isFolder()) {
            ZipEntry entry = new ZipEntry(exportRepositoryFile.getPath().substring(this.filePath.length() + 1) + "/");
            zos.putNextEntry(entry);
            this.exportDirectoryAsZip(exportRepositoryFile, zos);
        } else {
            this.exportFileAsZip(exportRepositoryFile, zos);
        }
        zos.close();
        return zipFile;
    }

    private void exportDirectoryAsZip(RepositoryFile repositoryDir, ZipOutputStream zos) throws IOException {
        List children = this.unifiedRepository.getChildren(repositoryDir.getId());
        for (RepositoryFile repoFile : children) {
            if (repoFile.isFolder()) {
                ZipEntry entry = new ZipEntry(repoFile.getPath().substring(this.filePath.length() + 1) + "/");
                zos.putNextEntry(entry);
                this.exportDirectoryAsZip(repoFile, zos);
                continue;
            }
            this.exportFileAsZip(repoFile, zos);
        }
    }

    private void exportFileAsZip(RepositoryFile exportRepositoryFile, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(exportRepositoryFile.getPath().substring(this.filePath.length() + 1));
        zos.putNextEntry(entry);
        SimpleRepositoryFileData repoFileData = (SimpleRepositoryFileData)this.unifiedRepository.getDataForRead(exportRepositoryFile.getId(), SimpleRepositoryFileData.class);
        InputStream is = repoFileData.getStream();
        IOUtils.copy((InputStream)is, (OutputStream)zos);
        zos.closeEntry();
        is.close();
    }

    public void exportDirectory(RepositoryFile repositoryDir, File parentDir) throws IOException {
        if (repositoryDir == null || !repositoryDir.isFolder()) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("Exporter.ERROR_0001_INVALID_SOURCE_DIRECTORY", new Object[]{repositoryDir == null ? "Null" : repositoryDir.getPath()}));
        }
        if (parentDir == null) {
            throw new FileNotFoundException(Messages.getInstance().getErrorString("Exporter.ERROR_0002_MISSING_DESTINATION"));
        }
        if (!(parentDir = new File(parentDir, repositoryDir.getName())).mkdirs()) {
            throw new IOException();
        }
        List children = this.unifiedRepository.getChildren(repositoryDir.getId());
        for (RepositoryFile repoFile : children) {
            if (repoFile.isFolder()) {
                this.exportDirectory(repoFile, parentDir);
                continue;
            }
            this.exportFile(repoFile, parentDir);
        }
    }

    public void exportFile(RepositoryFile exportRepositoryFile, File exportDirectory) throws IOException {
        if (exportDirectory.exists()) {
            if (!exportDirectory.isDirectory()) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("Exporter.ERROR_0004_INVALID_DESTINATION_DIRECTORY", new Object[]{exportDirectory.getAbsolutePath()}));
            }
        } else if (!exportDirectory.mkdirs()) {
            throw new IOException();
        }
        if (exportRepositoryFile == null) {
            throw new FileNotFoundException(Messages.getInstance().getErrorString("Exporter.ERROR_0001_INVALID_SOURCE_DIRECTORY", new Object[]{this.repoPath}));
        }
        SimpleRepositoryFileData repoFileData = (SimpleRepositoryFileData)this.unifiedRepository.getDataForRead(exportRepositoryFile.getId(), SimpleRepositoryFileData.class);
        InputStream is = repoFileData.getStream();
        File exportFile = new File(exportDirectory.getAbsolutePath() + File.separator + exportRepositoryFile.getName());
        FileOutputStream os = new FileOutputStream(exportFile);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        ((OutputStream)os).close();
        is.close();
    }

    public IUnifiedRepository getUnifiedRepository() {
        return this.unifiedRepository;
    }

    public void setUnifiedRepository(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    public String getRepoPath() {
        return this.repoPath;
    }

    public void setRepoPath(String repoPath) {
        this.repoPath = repoPath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public DefaultUnifiedRepositoryWebService getRepoWs() {
        return this.repoWs;
    }

    public void setRepoWs(DefaultUnifiedRepositoryWebService repoWs) {
        this.repoWs = repoWs;
    }
}

