/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.WriterAppender;
import org.pentaho.platform.plugin.services.importexport.RepositoryImportHTMLLayout;

public class Log4JRepositoryImportLog {
    private Logger logger;
    static final String FILE_KEY = "currentFile";
    private OutputStream outputStream;
    private String currentFilePath;
    private String logName;
    private String importRootPath;
    private Level logLevel;
    private WriterAppender writeAppender;

    Log4JRepositoryImportLog(OutputStream outputStream, String importRootPath, Level logLevel) {
        this.outputStream = outputStream;
        this.importRootPath = importRootPath;
        this.logLevel = logLevel;
        this.init();
    }

    private void init() {
        this.logName = "RepositoryImportLog." + this.getThreadName();
        this.logger = Logger.getLogger((String)this.logName);
        this.logger.setLevel(this.logLevel);
        RepositoryImportHTMLLayout htmlLayout = new RepositoryImportHTMLLayout(this.logLevel);
        htmlLayout.setTitle("Repository Import Log");
        this.writeAppender = new WriterAppender((Layout)htmlLayout, (Writer)new OutputStreamWriter(this.outputStream, Charset.forName("utf-8")));
        this.logger.addAppender((Appender)this.writeAppender);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public void setCurrentFilePath(String currentFilePath) {
        this.currentFilePath = currentFilePath;
        MDC.put((String)FILE_KEY, (Object)currentFilePath);
    }

    public String getImportRootPath() {
        return this.importRootPath;
    }

    protected void endJob() {
        try {
            this.outputStream.write(this.writeAppender.getLayout().getFooter().getBytes());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.logger.removeAppender(this.logName);
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }
}

