/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport.exportManifest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifestEntity;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifestFormatException;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestDto;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestEntityDto;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetadata;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMondrian;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;

public class ExportManifest {
    private HashMap<String, ExportManifestEntity> exportManifestEntities;
    private ExportManifestDto.ExportManifestInformation manifestInformation;
    private List<ExportManifestMetadata> metadataList = new ArrayList<ExportManifestMetadata>();
    private List<ExportManifestMondrian> mondrianList = new ArrayList<ExportManifestMondrian>();
    private List<JobScheduleRequest> scheduleList = new ArrayList<JobScheduleRequest>();
    private List<DatabaseConnection> datasourceList = new ArrayList<DatabaseConnection>();

    public ExportManifest() {
        this.exportManifestEntities = new HashMap();
        this.manifestInformation = new ExportManifestDto.ExportManifestInformation();
    }

    public ExportManifest(ExportManifestDto exportManifestDto) {
        this();
        this.manifestInformation = exportManifestDto.getExportManifestInformation();
        List<ExportManifestEntityDto> exportManifestEntityList = exportManifestDto.getExportManifestEntity();
        for (ExportManifestEntityDto exportManifestEntityDto : exportManifestEntityList) {
            this.exportManifestEntities.put(exportManifestEntityDto.getPath(), new ExportManifestEntity(exportManifestEntityDto));
        }
        this.mondrianList = exportManifestDto.getExportManifestMondrian();
        this.metadataList = exportManifestDto.getExportManifestMetadata();
        this.scheduleList = exportManifestDto.getExportManifestSchedule();
        this.datasourceList = exportManifestDto.getExportManifestDatasource();
    }

    public void add(RepositoryFile repositoryFile, RepositoryFileAcl repositoryFileAcl) throws ExportManifestFormatException {
        ExportManifestEntity exportManifestEntity = new ExportManifestEntity(this.manifestInformation.getRootFolder(), repositoryFile, repositoryFileAcl);
        this.add(exportManifestEntity);
    }

    public void add(File file, String userId, String projectId, Boolean isFolder, Boolean isHidden) throws ExportManifestFormatException {
        ExportManifestEntity exportManifestEntity = new ExportManifestEntity(file, userId, projectId, isFolder, isHidden);
        this.add(exportManifestEntity);
    }

    private void add(ExportManifestEntity exportManifestEntity) throws ExportManifestFormatException {
        if (!exportManifestEntity.isValid()) {
            throw new ExportManifestFormatException("Invalid Manifest Entry");
        }
        this.exportManifestEntities.put(exportManifestEntity.getPath(), exportManifestEntity);
    }

    public HashMap<String, ExportManifestEntity> getExportManifestEntities() {
        return this.exportManifestEntities;
    }

    public ExportManifestEntity getExportManifestEntity(String path) {
        return this.exportManifestEntities.get(path);
    }

    public void toXml(OutputStream outputStream) throws JAXBException, ExportManifestFormatException {
        if (!this.isValid()) {
            throw new ExportManifestFormatException("Invalid root Folder for manifest");
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExportManifestDto.class});
        Marshaller marshaller = this.getMarshaller();
        marshaller.marshal((Object)new JAXBElement(new QName("http://www.pentaho.com/schema/", "ExportManifest"), ExportManifestDto.class, (Object)this.getExportManifestDto()), outputStream);
    }

    public String toXmlString() throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = this.getMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)new JAXBElement(new QName("http://www.pentaho.com/schema/", "ExportManifest"), ExportManifestDto.class, (Object)this.getExportManifestDto()), (Writer)sw);
        return sw.toString();
    }

    private Marshaller getMarshaller() throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExportManifestDto.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }

    public static ExportManifest fromXml(ByteArrayInputStream input) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"org.pentaho.platform.plugin.services.importexport.exportManifest.bindings");
        Unmarshaller u = jc.createUnmarshaller();
        try {
            JAXBElement o = (JAXBElement)u.unmarshal((InputStream)input);
            ExportManifestDto exportManifestDto = (ExportManifestDto)o.getValue();
            ExportManifest exportManifest = new ExportManifest(exportManifestDto);
            return exportManifest;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    ExportManifestDto getExportManifestDto() {
        ExportManifestDto rawExportManifest = new ExportManifestDto();
        List<ExportManifestEntityDto> rawEntityList = rawExportManifest.getExportManifestEntity();
        rawExportManifest.setExportManifestInformation(this.manifestInformation);
        TreeSet<String> ts = new TreeSet<String>(this.exportManifestEntities.keySet());
        for (String path : ts) {
            rawEntityList.add(this.exportManifestEntities.get(path).getExportManifestEntityDto());
        }
        rawExportManifest.getExportManifestMetadata().addAll(this.metadataList);
        rawExportManifest.getExportManifestMondrian().addAll(this.mondrianList);
        rawExportManifest.getExportManifestSchedule().addAll(this.scheduleList);
        rawExportManifest.getExportManifestDatasource().addAll(this.datasourceList);
        return rawExportManifest;
    }

    public ExportManifestEntity createExportManifestEntry() {
        return new ExportManifestEntity();
    }

    public boolean isValid() {
        if (this.exportManifestEntities.size() > 0) {
            for (ExportManifestEntity manEntity : this.exportManifestEntities.values()) {
                if (manEntity.isValid()) continue;
                return false;
            }
            if (this.manifestInformation.getRootFolder() == null || this.manifestInformation.getRootFolder().length() == 0) {
                return false;
            }
        }
        return true;
    }

    public ExportManifestDto.ExportManifestInformation getManifestInformation() {
        return this.manifestInformation;
    }

    public void setManifestInformation(ExportManifestDto.ExportManifestInformation manifestInformation) {
        this.manifestInformation = manifestInformation;
    }

    public ExportManifestDto.ExportManifestInformation createExportManifestInformation() {
        return new ExportManifestDto.ExportManifestInformation();
    }

    public void addMetadata(ExportManifestMetadata metadata) {
        this.metadataList.add(metadata);
    }

    public void addMondrian(ExportManifestMondrian mondrian) {
        this.mondrianList.add(mondrian);
    }

    public void addSchedule(JobScheduleRequest schedule) {
        this.scheduleList.add(schedule);
    }

    public void addDatasource(DatabaseConnection connection) {
        this.datasourceList.add(connection);
    }

    public List<ExportManifestMetadata> getMetadataList() {
        return this.metadataList;
    }

    public List<ExportManifestMondrian> getMondrianList() {
        return this.mondrianList;
    }

    public List<JobScheduleRequest> getScheduleList() {
        return this.scheduleList;
    }

    public List<DatabaseConnection> getDatasourceList() {
        return this.datasourceList;
    }
}

