/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;

public class CompositeUserRoleListService
implements IUserRoleListService {
    private List<IUserRoleListService> delegates = new ArrayList<IUserRoleListService>();
    private STRATEGY activeStrategy = STRATEGY.FIRST_MATCH;

    public CompositeUserRoleListService(List<IUserRoleListService> delegates) {
        this.delegates.addAll(delegates);
    }

    public void setStrategy(STRATEGY strategy) {
        this.activeStrategy = strategy;
    }

    public void setStrategy(String strategy) {
        this.setStrategy(STRATEGY.valueOf(strategy));
    }

    public STRATEGY getActiveStrategy() {
        return this.activeStrategy;
    }

    public List<String> getAllRoles() {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getAllRoles();
            }
        });
    }

    public List<String> getSystemRoles() {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getSystemRoles();
            }
        });
    }

    public List<String> getAllRoles(final ITenant tenant) {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getAllRoles(tenant);
            }
        });
    }

    public List<String> getAllUsers() {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getAllUsers();
            }
        });
    }

    public List<String> getAllUsers(final ITenant tenant) {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getAllUsers(tenant);
            }
        });
    }

    public List<String> getUsersInRole(final ITenant tenant, final String role) {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getUsersInRole(tenant, role);
            }
        });
    }

    public List<String> getRolesForUser(final ITenant tenant, final String username) {
        return this.collectResultsForOperation(new CompositeOperation(){

            @Override
            public List<String> perform(IUserRoleListService service) {
                return service.getRolesForUser(tenant, username);
            }
        });
    }

    private List<String> collectResultsForOperation(CompositeOperation operation) {
        HashSet<String> returnVal = new HashSet<String>();
        for (IUserRoleListService delegate : this.delegates) {
            List<String> allFromDelegate;
            try {
                allFromDelegate = operation.perform(delegate);
            }
            catch (UnsupportedOperationException ignored) {
                continue;
            }
            if (allFromDelegate == null || allFromDelegate.size() <= 0) continue;
            returnVal.addAll(allFromDelegate);
            if (this.activeStrategy != STRATEGY.FIRST_MATCH) continue;
            return new ArrayList<String>(returnVal);
        }
        return new ArrayList<String>(returnVal);
    }

    private static interface CompositeOperation {
        public List<String> perform(IUserRoleListService var1);
    }

    public static enum STRATEGY {
        ADDITIVE,
        FIRST_MATCH;

    }
}

